/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.client.api.util;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.client.api.transform.MultiDependencyTransform;
import org.apache.inlong.manager.client.api.transform.SingleDependencyTransform;
import org.apache.inlong.manager.common.consts.InlongConstants;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.enums.TransformType;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.pojo.sort.util.StreamParseUtils;
import org.apache.inlong.manager.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.pojo.stream.StreamTransform;
import org.apache.inlong.manager.pojo.transform.TransformDefinition;
import org.apache.inlong.manager.pojo.transform.TransformRequest;
import org.apache.inlong.manager.pojo.transform.TransformResponse;

public class StreamTransformTransfer {
    public static TransformRequest createTransformRequest(StreamTransform streamTransform, InlongStreamInfo streamInfo) {
        TransformRequest transformRequest = new TransformRequest();
        Preconditions.expectNotBlank((String)streamTransform.getTransformName(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"TransformName should not be null");
        transformRequest.setTransformName(streamTransform.getTransformName());
        transformRequest.setInlongGroupId(streamInfo.getInlongGroupId());
        transformRequest.setInlongStreamId(streamInfo.getInlongStreamId());
        Preconditions.expectNotNull((Object)streamTransform.getTransformDefinition(), (String)"TransformDefinition should not be null");
        TransformDefinition transformDefinition = streamTransform.getTransformDefinition();
        transformRequest.setTransformType(transformDefinition.getTransformType().getType());
        transformRequest.setVersion(InlongConstants.INITIAL_VERSION);
        transformRequest.setTransformDefinition(JsonUtils.toJsonString((Object)transformDefinition));
        if (CollectionUtils.isNotEmpty((Collection)streamTransform.getPreNodes())) {
            transformRequest.setPreNodeNames(Joiner.on((String)",").join((Iterable)streamTransform.getPreNodes()));
        }
        if (CollectionUtils.isNotEmpty((Collection)streamTransform.getPostNodes())) {
            transformRequest.setPostNodeNames(Joiner.on((String)",").join((Iterable)streamTransform.getPostNodes()));
        }
        if (CollectionUtils.isNotEmpty((Collection)streamTransform.getFieldList())) {
            transformRequest.setFieldList(streamTransform.getFieldList());
        }
        return transformRequest;
    }

    public static StreamTransform parseStreamTransform(TransformResponse transformResponse) {
        TransformType transformType = TransformType.forType((String)transformResponse.getTransformType());
        String transformDefinitionStr = transformResponse.getTransformDefinition();
        TransformDefinition transformDefinition = StreamParseUtils.parseTransformDefinition((String)transformDefinitionStr, (TransformType)transformType);
        String transformName = transformResponse.getTransformName();
        String preNodeNames = transformResponse.getPreNodeNames();
        List preNodes = Splitter.on((String)",").splitToList((CharSequence)preNodeNames);
        StreamTransform streamTransform = preNodes.size() > 1 ? new MultiDependencyTransform(transformName, transformDefinition, preNodes.toArray(new String[0])) : new SingleDependencyTransform(transformName, transformDefinition, (String)preNodes.get(0));
        String postNodeNames = transformResponse.getPostNodeNames();
        if (StringUtils.isNotEmpty((CharSequence)postNodeNames)) {
            List postNodes = Splitter.on((String)",").splitToList((CharSequence)postNodeNames);
            streamTransform.setPostNodes((Set)Sets.newHashSet((Iterable)postNodes));
        }
        if (CollectionUtils.isNotEmpty((Collection)transformResponse.getFieldList())) {
            streamTransform.setFieldList(transformResponse.getFieldList());
        }
        return streamTransform;
    }
}

