/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.client.api.service;

import java.io.IOException;
import java.util.function.Supplier;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class AuthInterceptor
implements Interceptor {
    private final String username;
    private final String password;
    private final Supplier<String> tenantGetter;

    public AuthInterceptor(String username, String password, Supplier<String> tenantGetter) {
        this.username = username;
        this.password = password;
        this.tenantGetter = tenantGetter;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request oldRequest = chain.request();
        HttpUrl.Builder builder = oldRequest.url().newBuilder().addEncodedQueryParameter("username", this.username).addEncodedQueryParameter("password", this.password);
        Request newRequest = oldRequest.newBuilder().method(oldRequest.method(), oldRequest.body()).url(builder.build()).addHeader("tenant", this.tenantGetter.get()).build();
        return chain.proceed(newRequest);
    }
}

