/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.manager.service;

import com.google.gson.Gson;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.inlong.tubemq.manager.controller.TubeMQResult;
import org.apache.inlong.tubemq.manager.controller.group.request.DeleteOffsetReq;
import org.apache.inlong.tubemq.manager.controller.group.request.QueryConsumerGroupReq;
import org.apache.inlong.tubemq.manager.controller.group.request.QueryOffsetReq;
import org.apache.inlong.tubemq.manager.controller.group.result.AllBrokersOffsetRes;
import org.apache.inlong.tubemq.manager.controller.group.result.GroupOffsetRes;
import org.apache.inlong.tubemq.manager.controller.group.result.OffsetPartitionRes;
import org.apache.inlong.tubemq.manager.controller.group.result.OffsetQueryRes;
import org.apache.inlong.tubemq.manager.controller.group.result.TopicOffsetRes;
import org.apache.inlong.tubemq.manager.controller.node.request.CloneOffsetReq;
import org.apache.inlong.tubemq.manager.controller.topic.request.RebalanceConsumerReq;
import org.apache.inlong.tubemq.manager.controller.topic.request.RebalanceGroupReq;
import org.apache.inlong.tubemq.manager.entry.MasterEntry;
import org.apache.inlong.tubemq.manager.enums.ErrorCode;
import org.apache.inlong.tubemq.manager.service.TubeConst;
import org.apache.inlong.tubemq.manager.service.interfaces.BrokerService;
import org.apache.inlong.tubemq.manager.service.interfaces.MasterService;
import org.apache.inlong.tubemq.manager.service.interfaces.TopicService;
import org.apache.inlong.tubemq.manager.service.tube.CleanOffsetResult;
import org.apache.inlong.tubemq.manager.service.tube.RebalanceGroupResult;
import org.apache.inlong.tubemq.manager.service.tube.TopicView;
import org.apache.inlong.tubemq.manager.service.tube.TubeHttpGroupDetailInfo;
import org.apache.inlong.tubemq.manager.service.tube.TubeHttpTopicInfoList;
import org.apache.inlong.tubemq.manager.utils.ConvertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class TopicServiceImpl
implements TopicService {
    private static final Logger log = LoggerFactory.getLogger(TopicServiceImpl.class);
    public static final int FIRST_TOPIC_INDEX = 0;
    public static final int MINIMUN_TOPIC_RUN_PART = 1;
    private final CloseableHttpClient httpclient = HttpClients.createDefault();
    private final Gson gson = new Gson();
    private static final Pattern SPECIAL_CHAR_PATTERN = Pattern.compile("[%\\x00-\\x1F\\x7F-\\uFFFF]");
    private static final int MAX_TOPIC_NAME_LENGTH = 255;
    private static final String[] DANGEROUS_KEYWORDS = new String[]{"exec", "system", "cmd", "shell", "php", "perl", "python", "ruby", "javascript", "java"};
    @Value(value="${manager.broker.webPort:8081}")
    private int brokerWebPort;
    @Autowired
    private MasterService masterService;
    @Autowired
    private BrokerService brokerService;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public TubeHttpGroupDetailInfo requestGroupRunInfo(MasterEntry masterEntry, String group) {
        String url = "http://" + masterEntry.getIp() + ":" + masterEntry.getWebPort() + "/webapi.htm?type=op_query&method=admin_query_consume_group_detail" + "&consumeGroup=" + group;
        HttpGet httpget = new HttpGet(url);
        try (CloseableHttpResponse response = this.httpclient.execute((HttpUriRequest)httpget);){
            TubeHttpGroupDetailInfo groupDetailInfo = (TubeHttpGroupDetailInfo)this.gson.fromJson((Reader)new InputStreamReader(response.getEntity().getContent(), StandardCharsets.UTF_8), TubeHttpGroupDetailInfo.class);
            if (groupDetailInfo.getErrCode() != 0) return null;
            TubeHttpGroupDetailInfo tubeHttpGroupDetailInfo = groupDetailInfo;
            return tubeHttpGroupDetailInfo;
        }
        catch (Exception ex) {
            log.error("exception caught while requesting group status", (Throwable)ex);
        }
        return null;
    }

    @Override
    public TubeMQResult queryGroupExist(QueryConsumerGroupReq req) {
        MasterEntry masterNode = this.masterService.getMasterNode(req);
        TubeHttpGroupDetailInfo groupDetailInfo = this.requestGroupRunInfo(masterNode, req.getConsumerGroup());
        List<String> topicSet = groupDetailInfo.getTopicSet();
        if (topicSet.stream().anyMatch(topic -> topic.equals(req.getTopicName()))) {
            return TubeMQResult.successResult();
        }
        return TubeMQResult.errorResult("no such group");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public TopicView requestTopicViewInfo(Long clusterId, String topicName) {
        MasterEntry masterNode = this.masterService.getMasterNode(clusterId);
        this.validateMasterEntry(masterNode, clusterId);
        this.validateTopicName(topicName, clusterId);
        String url = this.buildTopicViewURL(masterNode, topicName, clusterId);
        HttpGet httpget = new HttpGet(url);
        try (CloseableHttpResponse response = this.httpclient.execute((HttpUriRequest)httpget);){
            TopicView topicView = this.parseTopicViewResponse(response);
            return topicView;
        }
        catch (Exception ex) {
            this.handleRequestException(clusterId, topicName, ex);
            throw new RuntimeException(ex.getMessage());
        }
    }

    private void validateMasterEntry(MasterEntry masterNode, Long clusterId) {
        if (masterNode == null || StringUtils.isBlank((CharSequence)masterNode.getIp()) || masterNode.getWebPort() <= 0) {
            log.error("Invalid MasterEntry: ClusterId = {}", (Object)clusterId);
            throw new IllegalArgumentException("Invalid MasterEntry.");
        }
    }

    private void validateTopicName(String topicName, Long clusterId) {
        if (StringUtils.isBlank((CharSequence)topicName) || this.containsDangerousChars(topicName) || topicName.length() > 255) {
            log.error("Invalid topicName: ClusterId = {}, TopicName = {}", (Object)clusterId, (Object)topicName);
            throw new IllegalArgumentException("Invalid topicName.");
        }
    }

    private String buildTopicViewURL(MasterEntry masterNode, String topicName, Long clusterId) {
        String url = "http://" + masterNode.getIp() + ":" + masterNode.getWebPort() + "/webapi.htm?type=op_query&method=admin_query_cluster_topic_view";
        if (!this.isValidURL(url)) {
            log.error("Invalid URL: ClusterId = {}, URL = {}", (Object)clusterId, (Object)url);
            throw new IllegalArgumentException("Invalid URL.");
        }
        return url + "&topicName=" + topicName;
    }

    private TopicView parseTopicViewResponse(CloseableHttpResponse response) throws Exception {
        return (TopicView)this.gson.fromJson((Reader)new InputStreamReader(response.getEntity().getContent(), StandardCharsets.UTF_8), TopicView.class);
    }

    private void handleRequestException(Long clusterId, String topicName, Exception ex) {
        log.error("Exception caught while requesting topic view: ClusterId = {}, TopicName = {}", new Object[]{clusterId, topicName, ex});
    }

    private boolean containsDangerousChars(String input) {
        if ((input = input.toLowerCase()).contains("://")) {
            return true;
        }
        if (StringUtils.containsAny((CharSequence)input, (CharSequence[])DANGEROUS_KEYWORDS)) {
            return true;
        }
        Matcher matcher = SPECIAL_CHAR_PATTERN.matcher(input);
        return matcher.find();
    }

    private boolean isValidURL(String url) {
        try {
            new URL(url);
            return true;
        }
        catch (MalformedURLException e) {
            log.warn("URL validation failed with exception: {}", (Object)e.getMessage());
            return false;
        }
    }

    @Override
    public TubeMQResult cloneOffsetToOtherGroups(CloneOffsetReq req) {
        MasterEntry master = this.masterService.getMasterNode((long)req.getClusterId());
        if (master == null) {
            return TubeMQResult.errorResult("no such cluster");
        }
        TubeHttpTopicInfoList topicInfoList = this.requestTopicConfigInfo(master, req.getTopicName());
        TubeMQResult result = new TubeMQResult();
        if (topicInfoList == null) {
            return result;
        }
        List<TubeHttpTopicInfoList.TopicInfoList.TopicInfo> topicInfos = topicInfoList.getTopicInfo();
        for (TubeHttpTopicInfoList.TopicInfoList.TopicInfo topicInfo : topicInfos) {
            result = this.brokerService.cloneOffset(topicInfo.getBrokerIp(), this.brokerWebPort, req);
            if (result.getErrCode() == TubeConst.SUCCESS_CODE.intValue()) continue;
            return result;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public TubeHttpTopicInfoList requestTopicConfigInfo(MasterEntry masterEntry, String topic) {
        String url = "http://" + masterEntry.getIp() + ":" + masterEntry.getWebPort() + "/webapi.htm?type=op_query&method=admin_query_topic_info" + "&topicName=" + topic;
        HttpGet httpget = new HttpGet(url);
        try (CloseableHttpResponse response = this.httpclient.execute((HttpUriRequest)httpget);){
            TubeHttpTopicInfoList topicInfoList = (TubeHttpTopicInfoList)this.gson.fromJson((Reader)new InputStreamReader(response.getEntity().getContent(), StandardCharsets.UTF_8), TubeHttpTopicInfoList.class);
            if (topicInfoList.getErrCode() == TubeConst.SUCCESS_CODE.intValue()) {
                TubeHttpTopicInfoList tubeHttpTopicInfoList = topicInfoList;
                return tubeHttpTopicInfoList;
            }
            log.error("exception caught while requesting topic config info {}", (Object)topicInfoList.getErrMsg());
            return null;
        }
        catch (Exception ex) {
            log.error("exception caught while requesting broker status", (Throwable)ex);
        }
        return null;
    }

    @Override
    public TubeMQResult rebalanceGroup(RebalanceGroupReq req) {
        MasterEntry master = this.masterService.getMasterNode((long)req.getClusterId());
        if (master == null) {
            return TubeMQResult.errorResult("no such cluster");
        }
        List<String> consumerIds = Objects.requireNonNull(this.requestGroupRunInfo(master, req.getGroupName())).getConsumerIds();
        RebalanceGroupResult rebalanceGroupResult = new RebalanceGroupResult();
        consumerIds.forEach(consumerId -> {
            RebalanceConsumerReq rebalanceConsumerReq = ConvertUtils.convertToRebalanceConsumerReq(req, consumerId);
            String url = "http://" + master.getIp() + ":" + master.getWebPort() + "/" + "webapi.htm" + "?" + ConvertUtils.convertReqToQueryStr(rebalanceConsumerReq);
            TubeMQResult result = this.masterService.requestMaster(url);
            if (result.getErrCode() != 0) {
                rebalanceGroupResult.getFailConsumers().add((String)consumerId);
            }
            rebalanceGroupResult.getSuccessConsumers().add((String)consumerId);
        });
        TubeMQResult tubeResult = new TubeMQResult();
        tubeResult.setData(this.gson.toJson((Object)rebalanceGroupResult));
        return tubeResult;
    }

    @Override
    public TubeMQResult deleteOffset(DeleteOffsetReq req) {
        MasterEntry master = this.masterService.getMasterNode((long)req.getClusterId());
        if (master == null) {
            return TubeMQResult.errorResult("no such cluster");
        }
        TubeHttpTopicInfoList topicInfoList = this.requestTopicConfigInfo(master, req.getTopicName());
        TubeMQResult result = new TubeMQResult();
        CleanOffsetResult cleanOffsetResult = new CleanOffsetResult();
        if (topicInfoList == null) {
            return TubeMQResult.errorResult("no such topic");
        }
        List<TubeHttpTopicInfoList.TopicInfoList.TopicInfo> topicInfos = topicInfoList.getTopicInfo();
        for (TubeHttpTopicInfoList.TopicInfoList.TopicInfo topicInfo : topicInfos) {
            String brokerIp = topicInfo.getBrokerIp();
            result = this.brokerService.deleteOffset(brokerIp, this.brokerWebPort, req);
            if (result.getErrCode() != TubeConst.SUCCESS_CODE.intValue()) {
                cleanOffsetResult.getFailBrokers().add(brokerIp);
                continue;
            }
            cleanOffsetResult.getSuccessBrokers().add(brokerIp);
        }
        result.setData(this.gson.toJson((Object)cleanOffsetResult));
        return result;
    }

    @Override
    public TubeMQResult queryOffset(QueryOffsetReq req) {
        MasterEntry master = this.masterService.getMasterNode((long)req.getClusterId());
        if (master == null) {
            return TubeMQResult.errorResult("no such cluster");
        }
        TubeHttpTopicInfoList topicInfoList = this.requestTopicConfigInfo(master, req.getTopicName());
        TubeMQResult result = new TubeMQResult();
        if (topicInfoList == null) {
            return TubeMQResult.errorResult("no such topic");
        }
        List<TubeHttpTopicInfoList.TopicInfoList.TopicInfo> topicInfos = topicInfoList.getTopicInfo();
        AllBrokersOffsetRes allBrokersOffsetRes = new AllBrokersOffsetRes();
        List<AllBrokersOffsetRes.OffsetInfo> offsetPerBroker = allBrokersOffsetRes.getOffsetPerBroker();
        for (TubeHttpTopicInfoList.TopicInfoList.TopicInfo topicInfo : topicInfos) {
            OffsetQueryRes res = this.brokerService.queryOffset(topicInfo.getBrokerIp(), this.brokerWebPort, req);
            if (res.getErrCode() != TubeConst.SUCCESS_CODE.intValue()) {
                return TubeMQResult.errorResult("query broker id" + topicInfo.getBrokerId() + " fail");
            }
            this.generateOffsetInfo(offsetPerBroker, topicInfo, res);
        }
        result.setData(allBrokersOffsetRes);
        return result;
    }

    @Override
    public TubeMQResult queryCanWrite(String topicName, Long clusterId) {
        TopicView topicView = this.requestTopicViewInfo(clusterId, topicName);
        List<TopicView.TopicViewInfo> data = topicView.getData();
        if (CollectionUtils.isEmpty(data)) {
            return TubeMQResult.errorResult(ErrorCode.NO_SUCH_TOPIC);
        }
        TopicView.TopicViewInfo topicViewInfo = data.get(0);
        if (topicViewInfo.getTotalRunNumPartCount() >= 1) {
            return TubeMQResult.successResult();
        }
        return TubeMQResult.errorResult(ErrorCode.TOPIC_NOT_WRITABLE);
    }

    private void generateOffsetInfo(List<AllBrokersOffsetRes.OffsetInfo> offsetPerBroker, TubeHttpTopicInfoList.TopicInfoList.TopicInfo topicInfo, OffsetQueryRes res) {
        AllBrokersOffsetRes.OffsetInfo offsetInfo = new AllBrokersOffsetRes.OffsetInfo();
        offsetInfo.setBrokerId(topicInfo.getBrokerId());
        offsetInfo.setBrokerIp(topicInfo.getBrokerIp());
        if (TubeConst.SUCCESS_CODE.intValue() == res.getErrCode()) {
            List<GroupOffsetRes> dataSet = res.getDataSet();
            for (GroupOffsetRes groupOffsetRes : dataSet) {
                for (TopicOffsetRes topicOffsetRes : groupOffsetRes.getSubInfo()) {
                    List<OffsetPartitionRes> offsets = topicOffsetRes.getOffsets();
                    offsetInfo.setOffsets(offsets);
                }
            }
            offsetPerBroker.add(offsetInfo);
        }
    }
}

