/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.manager.controller.task;

import com.google.gson.Gson;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.inlong.tubemq.manager.controller.TubeMQResult;
import org.apache.inlong.tubemq.manager.controller.topic.request.AddTopicTask;
import org.apache.inlong.tubemq.manager.controller.topic.request.BatchAddTopicTaskReq;
import org.apache.inlong.tubemq.manager.entry.ClusterEntry;
import org.apache.inlong.tubemq.manager.service.interfaces.ClusterService;
import org.apache.inlong.tubemq.manager.service.interfaces.TaskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/v1/task"})
public class TaskController {
    private static final Logger log = LoggerFactory.getLogger(TaskController.class);
    @Autowired
    private ClusterService clusterService;
    @Autowired
    private TaskService taskService;
    private Gson gson = new Gson();

    @RequestMapping(value={""})
    @ResponseBody
    public TubeMQResult taskMethodProxy(@RequestParam String method, @RequestBody String req) {
        switch (method) {
            case "addTopicTask": {
                return this.addTask((BatchAddTopicTaskReq)this.gson.fromJson(req, BatchAddTopicTaskReq.class));
            }
        }
        return TubeMQResult.errorResult("no such method");
    }

    public TubeMQResult addTask(BatchAddTopicTaskReq req) {
        if (!req.legal()) {
            return TubeMQResult.errorResult("param illegal");
        }
        ClusterEntry clusterEntry = this.clusterService.getOneCluster(req.getClusterId());
        if (clusterEntry == null) {
            return TubeMQResult.errorResult("no such cluster");
        }
        Set<String> topicNames = req.getAddTopicTasks().stream().map(AddTopicTask::getTopicName).collect(Collectors.toSet());
        return this.taskService.addTopicCreateTask(req.getClusterId(), topicNames);
    }
}

