/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.manager;

import java.util.concurrent.Executor;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.data.jpa.repository.config.EnableJpaAuditing;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@SpringBootApplication
@EnableJpaAuditing
@EnableAsync
@EnableScheduling
@EnableConfigurationProperties
public class TubeMQManager {
    @Value(value="${manager.async.core.pool.size:15}")
    private int asyncCorePoolSize;
    @Value(value="${manager.async.max.pool.size:20}")
    private int asyncMaxPoolSize;
    @Value(value="${manager.async.queue.capacity:100}")
    private int asyncQueueCapacity;
    @Value(value="${manager.async.thread.prefix:AsyncThread-}")
    private String threadPrefix;

    public static void main(String[] args) {
        SpringApplication.run(TubeMQManager.class, (String[])new String[0]);
    }

    @Bean(name={"asyncExecutor"})
    public Executor asyncExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(this.asyncCorePoolSize);
        executor.setMaxPoolSize(this.asyncMaxPoolSize);
        executor.setQueueCapacity(this.asyncQueueCapacity);
        executor.setThreadNamePrefix(this.threadPrefix);
        executor.initialize();
        return executor;
    }
}

