/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.tool.excel;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ExcelCellDataTransfer {
    DATE{
        final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        @Override
        String parse2Text(Object cellValue) {
            if (cellValue == null) {
                return null;
            }
            if (cellValue instanceof Date) {
                Date date = (Date)cellValue;
                return this.simpleDateFormat.format(date);
            }
            return String.valueOf(cellValue);
        }

        @Override
        Object parseFromText(String cellValue) {
            if (StringUtils.isNotBlank((CharSequence)cellValue)) {
                Date date = null;
                try {
                    date = this.simpleDateFormat.parse(cellValue);
                }
                catch (ParseException e) {
                    LOGGER.error("Can not properly parse value in Date type: " + cellValue, (Throwable)e);
                }
                return date;
            }
            return cellValue;
        }
    }
    ,
    NONE{

        @Override
        String parse2Text(Object o) {
            return String.valueOf(o);
        }

        @Override
        Object parseFromText(String s) {
            return s;
        }
    };

    protected static final Logger LOGGER;

    abstract String parse2Text(Object var1);

    abstract Object parseFromText(String var1);

    static {
        LOGGER = LoggerFactory.getLogger(ExcelCellDataTransfer.class);
    }
}

