/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core.support;

import java.util.List;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.data.rest.core.support.EntityLookup;
import org.springframework.data.rest.core.support.SelfLinkProvider;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.server.EntityLinks;
import org.springframework.lang.Nullable;
import org.springframework.plugin.core.PluginRegistry;
import org.springframework.util.Assert;

public class DefaultSelfLinkProvider
implements SelfLinkProvider {
    private final PersistentEntities entities;
    private final EntityLinks entityLinks;
    private final PluginRegistry<EntityLookup<?>, Class<?>> lookups;
    private final ConversionService conversionService;

    public DefaultSelfLinkProvider(PersistentEntities entities, EntityLinks entityLinks, List<? extends EntityLookup<?>> lookups, ConversionService conversionService) {
        Assert.notNull((Object)entities, (String)"PersistentEntities must not be null!");
        Assert.notNull((Object)entityLinks, (String)"EntityLinks must not be null!");
        Assert.notNull(lookups, (String)"EntityLookups must not be null!");
        this.entities = entities;
        this.entityLinks = entityLinks;
        this.lookups = PluginRegistry.of(lookups);
        this.conversionService = conversionService;
    }

    @Override
    public Link createSelfLinkFor(Object instance) {
        Assert.notNull((Object)instance, (String)"Domain object must not be null!");
        return this.createSelfLinkFor(instance.getClass(), instance);
    }

    @Override
    public Link createSelfLinkFor(Class<?> type, Object reference) {
        if (type.isInstance(reference)) {
            return this.entityLinks.linkToItemResource(type, this.getResourceId(type, reference));
        }
        PersistentEntity entity = this.entities.getRequiredPersistentEntity(type);
        PersistentProperty idProperty = entity.getRequiredIdProperty();
        Object identifier = this.conversionService.convert(reference, idProperty.getType());
        if (this.lookups.hasPluginFor(type)) {
            identifier = this.getResourceId(type, this.conversionService.convert(identifier, type));
        }
        return this.entityLinks.linkToItemResource(type, identifier);
    }

    @Nullable
    private Object getResourceId(Class<?> type, Object reference) {
        if (!this.lookups.hasPluginFor(type)) {
            return this.entityIdentifierOrNull(reference);
        }
        return this.lookups.getPluginFor(type).map(it -> (EntityLookup)it.getClass().cast(it)).map(it -> it.getResourceIdentifier(reference)).orElseGet(() -> this.entityIdentifierOrNull(reference));
    }

    private Object entityIdentifierOrNull(Object instance) {
        return this.entities.getRequiredPersistentEntity(instance.getClass()).getIdentifierAccessor(instance).getIdentifier();
    }
}

