/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.dataproxy.utils;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;

public class DateTimeUtils {
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMddHHmm");
    private static final ZoneId defZoneId = ZoneId.systemDefault();

    public static String ms2yyyyMMddHHmm(long timestamp) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), defZoneId);
        return DATE_FORMATTER.format(localDateTime);
    }

    public static String ms2yyyyMMddHHmmTenMins(long timestamp) {
        long longDataTime = timestamp / 1000L / 60L / 10L;
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(longDataTime * 1000L * 60L * 10L), defZoneId);
        return DATE_FORMATTER.format(localDateTime);
    }
}

