/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.dataproxy.sink.mq;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.flume.Context;
import org.apache.flume.conf.Configurable;
import org.apache.inlong.dataproxy.config.pojo.CacheClusterConfig;
import org.apache.inlong.dataproxy.sink.mq.CacheClusterSelector;
import org.apache.pulsar.shade.org.apache.commons.lang.math.NumberUtils;

public class RandomCacheClusterSelector
implements CacheClusterSelector,
Configurable {
    public static final String KEY_CACHE_CLUSTER_PRODUCER_SIZE = "cacheClusterProducerSize";
    public static final int DEFAULT_CACHE_CLUSTER_PRODUCER_SIZE = 1;
    public static final String KEY_CACHE_CLUSTER_RESELECT_INTERVAL_MINUTES = "cacheClusterReselectIntervalMinutes";
    public static final int DEFAULT_CACHE_CLUSTER_RESELECT_INTERVAL_MINUTES = 10;
    private Context context;
    private long lastCacheClusterSelectTime = 0L;
    private HashSet<String> currentClusterNames = new HashSet();

    @Override
    public List<CacheClusterConfig> select(List<CacheClusterConfig> allConfigList) {
        boolean needReselectCacheCluster;
        ArrayList<CacheClusterConfig> newConfigList = new ArrayList<CacheClusterConfig>();
        HashSet newClusterNames = new HashSet();
        allConfigList.forEach(v -> newClusterNames.add(v.getClusterName()));
        int cacheClusterReselectIntervalMinutes = NumberUtils.toInt((String)this.context.getString(KEY_CACHE_CLUSTER_RESELECT_INTERVAL_MINUTES), (int)10);
        long cacheClusterReselectIntervalMs = cacheClusterReselectIntervalMinutes * 60 * 1000;
        boolean bl = needReselectCacheCluster = System.currentTimeMillis() - this.lastCacheClusterSelectTime > cacheClusterReselectIntervalMs;
        if (newClusterNames.equals(this.currentClusterNames) && !needReselectCacheCluster) {
            return newConfigList;
        }
        this.lastCacheClusterSelectTime = System.currentTimeMillis();
        this.currentClusterNames = newClusterNames;
        SecureRandom rand = new SecureRandom();
        int cacheClusterProducerSize = NumberUtils.toInt((String)this.context.getString(KEY_CACHE_CLUSTER_PRODUCER_SIZE), (int)1);
        int maxClusterSize = Math.min(cacheClusterProducerSize, allConfigList.size());
        ArrayList<CacheClusterConfig> randomList = new ArrayList<CacheClusterConfig>(allConfigList);
        for (int i = 0; i < maxClusterSize; ++i) {
            int index = rand.nextInt(randomList.size());
            CacheClusterConfig config = (CacheClusterConfig)randomList.remove(index);
            newConfigList.add(config);
        }
        return newConfigList;
    }

    public void configure(Context context) {
        this.context = context;
    }
}

