/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.dataproxy.metrics.audit;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.flume.Event;
import org.apache.inlong.audit.AuditIdEnum;
import org.apache.inlong.audit.AuditOperator;
import org.apache.inlong.audit.entity.AuditComponent;
import org.apache.inlong.audit.util.AuditConfig;
import org.apache.inlong.common.enums.MessageWrapType;
import org.apache.inlong.dataproxy.config.CommonConfigHolder;
import org.apache.inlong.dataproxy.metrics.DataProxyMetricItem;

public class AuditUtils {
    private static int auditIdReadSuccess = 5;
    private static int auditIdSendSuccess = 6;

    public static void initAudit() {
        if (CommonConfigHolder.getInstance().isEnableAudit()) {
            if (CommonConfigHolder.getInstance().isEnableAuditProxysDiscoveryFromManager()) {
                AuditOperator.getInstance().setAuditProxy(AuditComponent.DATAPROXY, CommonConfigHolder.getInstance().getManagerHosts().get(0), CommonConfigHolder.getInstance().getManagerAuthSecretId(), CommonConfigHolder.getInstance().getManagerAuthSecretKey());
            } else {
                AuditOperator.getInstance().setAuditProxy(CommonConfigHolder.getInstance().getAuditProxys());
            }
            AuditConfig auditConfig = new AuditConfig(CommonConfigHolder.getInstance().getAuditFilePath(), CommonConfigHolder.getInstance().getAuditMaxCacheRows());
            AuditOperator.getInstance().setAuditConfig(auditConfig);
            auditIdReadSuccess = AuditOperator.getInstance().buildSuccessfulAuditId(AuditIdEnum.DATA_PROXY_INPUT);
            auditIdSendSuccess = AuditOperator.getInstance().buildSuccessfulAuditId(AuditIdEnum.DATA_PROXY_OUTPUT);
        }
    }

    public static void addInputSuccess(Event event) {
        if (event == null || !CommonConfigHolder.getInstance().isEnableAudit()) {
            return;
        }
        AuditUtils.addAuditData(event, auditIdReadSuccess);
    }

    public static void addOutputSuccess(Event event) {
        if (event == null || !CommonConfigHolder.getInstance().isEnableAudit()) {
            return;
        }
        AuditUtils.addAuditData(event, auditIdSendSuccess);
    }

    private static void addAuditData(Event event, int auditID) {
        Map headers = event.getHeaders();
        String pkgVersion = (String)headers.get("msgEnType");
        if (MessageWrapType.INLONG_MSG_V1.getStrId().equalsIgnoreCase(pkgVersion)) {
            String inlongGroupId = DataProxyMetricItem.getInlongGroupId(headers);
            String inlongStreamId = DataProxyMetricItem.getInlongStreamId(headers);
            long logTime = AuditUtils.getLogTime(headers);
            long msgCount = 1L;
            if (event.getHeaders().containsKey("msgcnt")) {
                msgCount = Long.parseLong((String)event.getHeaders().get("msgcnt"));
            }
            long auditVersion = AuditUtils.getAuditVersion(headers);
            AuditOperator.getInstance().add(auditID, "-1", inlongGroupId, inlongStreamId, logTime, msgCount, (long)event.getBody().length, auditVersion);
        } else {
            String groupId = (String)headers.get("groupId");
            String streamId = (String)headers.get("streamId");
            long dataTime = NumberUtils.toLong((String)((String)headers.get("dt")));
            long msgCount = NumberUtils.toLong((String)((String)headers.get("msgcnt")));
            long auditVersion = AuditUtils.getAuditVersion(headers);
            AuditOperator.getInstance().add(auditID, "-1", groupId, streamId, dataTime, msgCount, (long)event.getBody().length, auditVersion);
        }
    }

    public static long getLogTime(Map<String, String> headers) {
        String strLogTime = headers.get("msgTime");
        if (strLogTime == null) {
            strLogTime = headers.get("dt");
        }
        if (strLogTime == null) {
            return System.currentTimeMillis();
        }
        long logTime = NumberUtils.toLong((String)strLogTime, (long)0L);
        if (logTime == 0L) {
            logTime = System.currentTimeMillis();
        }
        return logTime;
    }

    public static long getLogTime(Event event) {
        if (event != null) {
            return AuditUtils.getLogTime(event.getHeaders());
        }
        return System.currentTimeMillis();
    }

    public static long getAuditFormatTime(long msgTime) {
        return msgTime - msgTime % CommonConfigHolder.getInstance().getAuditFormatInvlMs();
    }

    public static long getAuditVersion(Map<String, String> headers) {
        String strAuditVersion = headers.get("auditVersion");
        if (StringUtils.isNotBlank((CharSequence)strAuditVersion)) {
            try {
                return Long.parseLong(strAuditVersion);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return -1L;
    }

    public static void send() {
        AuditOperator.getInstance().flush();
    }
}

