/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.dataproxy.metrics;

import java.util.HashMap;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.flume.Event;
import org.apache.inlong.common.metric.MetricDomain;
import org.apache.inlong.common.metric.MetricItemSet;
import org.apache.inlong.dataproxy.config.CommonConfigHolder;
import org.apache.inlong.dataproxy.metrics.DataProxyMetricItem;

@MetricDomain(name="DataProxy")
public class DataProxyMetricItemSet
extends MetricItemSet<DataProxyMetricItem> {
    private String clusterId = null;
    private String sourceDataId = null;

    public DataProxyMetricItemSet(String name) {
        super(name);
    }

    public DataProxyMetricItemSet(String clusterId, String name) {
        super(name);
        this.clusterId = clusterId;
    }

    public DataProxyMetricItemSet(String clusterId, String name, String sourceDataId) {
        super(name);
        this.clusterId = clusterId;
        this.sourceDataId = sourceDataId;
    }

    public void fillSrcMetricItemsByEvent(Event event, boolean isSuccess, long size) {
        this.fillMetricItemsByEvent(event, true, true, isSuccess, size, 0L);
    }

    public void fillSinkSendMetricItemsByEvent(Event event, long sentTime, boolean isSuccess, long size) {
        this.fillMetricItemsByEvent(event, false, false, isSuccess, size, sentTime);
    }

    private void fillMetricItemsByEvent(Event event, boolean isSource, boolean isReadOp, boolean isSuccess, long size, long sendTime) {
        HashMap<String, String> dimensions = new HashMap<String, String>();
        dimensions.put("clusterId", this.clusterId);
        dimensions.put("inlongGroupId", (String)event.getHeaders().get("groupId"));
        dimensions.put("inlongStreamId", (String)event.getHeaders().get("streamId"));
        long dataTime = NumberUtils.toLong((String)((String)event.getHeaders().get("dt")));
        long msgCount = NumberUtils.toLong((String)((String)event.getHeaders().get("msgcnt")));
        long auditFormatTime = dataTime - dataTime % CommonConfigHolder.getInstance().getAuditFormatInvlMs();
        dimensions.put("msgTime", String.valueOf(auditFormatTime));
        if (isSource) {
            dimensions.put("sourceId", this.name);
            dimensions.put("sourceDataId", this.sourceDataId);
        } else {
            dimensions.put("sinkId", this.name);
            dimensions.put("sinkDataId", (String)event.getHeaders().get("topic"));
        }
        DataProxyMetricItem metricItem = (DataProxyMetricItem)this.findMetricItem(dimensions);
        if (isReadOp) {
            if (isSuccess) {
                metricItem.readSuccessCount.addAndGet(msgCount);
                metricItem.readSuccessSize.addAndGet(size);
            } else {
                metricItem.readFailCount.addAndGet(msgCount);
                metricItem.readFailSize.addAndGet(size);
            }
        } else {
            if (isSuccess) {
                metricItem.sendSuccessCount.addAndGet(msgCount);
                metricItem.sendSuccessSize.addAndGet(size);
                if (sendTime > 0L) {
                    long currentTime = System.currentTimeMillis();
                    long msgDataTimeL = Long.parseLong((String)event.getHeaders().get("dt"));
                    long msgRcvTimeL = Long.parseLong((String)event.getHeaders().get("rt"));
                    metricItem.sinkDuration.addAndGet(currentTime - sendTime);
                    metricItem.nodeDuration.addAndGet(currentTime - msgRcvTimeL);
                    metricItem.wholeDuration.addAndGet(currentTime - msgDataTimeL);
                }
            } else {
                metricItem.sendFailCount.addAndGet(msgCount);
                metricItem.sendFailSize.addAndGet(size);
            }
            metricItem.sendCount.addAndGet(msgCount);
            metricItem.sendSize.addAndGet(size);
        }
    }

    protected DataProxyMetricItem createItem() {
        return new DataProxyMetricItem();
    }
}

