/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.dataproxy.dispatch;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.inlong.sdk.commons.protocol.ProxySdk;
import org.apache.inlong.sdk.commons.protocol.SourceCallback;

public class DispatchProfileCallback {
    private AtomicInteger ackingCount;
    private SourceCallback callback;

    public DispatchProfileCallback(int totalCount, SourceCallback callback) {
        this.ackingCount = new AtomicInteger(totalCount);
        this.callback = callback;
    }

    public void ack(int eventCount) {
        int currentCount = this.ackingCount.addAndGet(-eventCount);
        if (currentCount <= 0) {
            this.callback.callback(ProxySdk.ResultCode.SUCCUSS);
        }
    }

    public void fail() {
        this.callback.callback(ProxySdk.ResultCode.ERR_REJECT);
    }
}

