/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.conf;

import java.util.Locale;
import org.apache.flume.conf.ComponentConfiguration;
import org.apache.flume.conf.ConfigurationException;
import org.apache.flume.conf.channel.ChannelConfiguration;
import org.apache.flume.conf.channel.ChannelSelectorConfiguration;
import org.apache.flume.conf.configfilter.ConfigFilterConfiguration;
import org.apache.flume.conf.sink.SinkConfiguration;
import org.apache.flume.conf.sink.SinkGroupConfiguration;
import org.apache.flume.conf.sink.SinkProcessorConfiguration;
import org.apache.flume.conf.source.SourceConfiguration;

public class ComponentConfigurationFactory {
    public static ComponentConfiguration create(String name, String type, ComponentConfiguration.ComponentType component) throws ConfigurationException {
        Class<?> confType = null;
        if (type == null) {
            throw new ConfigurationException("Cannot create component without knowing its type!");
        }
        try {
            confType = Class.forName(type);
            return (ComponentConfiguration)confType.getConstructor(String.class).newInstance(type);
        }
        catch (Exception ignored) {
            try {
                type = type.toUpperCase(Locale.ENGLISH);
                switch (component) {
                    case SOURCE: {
                        return SourceConfiguration.SourceConfigurationType.valueOf(type.toUpperCase(Locale.ENGLISH)).getConfiguration(name);
                    }
                    case CONFIG_FILTER: {
                        return ConfigFilterConfiguration.ConfigFilterConfigurationType.valueOf(type.toUpperCase(Locale.ENGLISH)).getConfiguration(name);
                    }
                    case SINK: {
                        return SinkConfiguration.SinkConfigurationType.valueOf(type.toUpperCase(Locale.ENGLISH)).getConfiguration(name);
                    }
                    case CHANNEL: {
                        return ChannelConfiguration.ChannelConfigurationType.valueOf(type.toUpperCase(Locale.ENGLISH)).getConfiguration(name);
                    }
                    case SINK_PROCESSOR: {
                        return SinkProcessorConfiguration.SinkProcessorConfigurationType.valueOf(type.toUpperCase(Locale.ENGLISH)).getConfiguration(name);
                    }
                    case CHANNELSELECTOR: {
                        return ChannelSelectorConfiguration.ChannelSelectorConfigurationType.valueOf(type.toUpperCase(Locale.ENGLISH)).getConfiguration(name);
                    }
                    case SINKGROUP: {
                        return new SinkGroupConfiguration(name);
                    }
                }
                throw new ConfigurationException("Cannot create configuration. Unknown Type specified: " + type);
            }
            catch (ConfigurationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ConfigurationException("Could not create configuration!  Due to " + e.getClass().getSimpleName() + ": " + e.getMessage(), e);
            }
        }
    }
}

