/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.formats.base;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.inlong.sort.formats.base.TableFormatConstants;

@PublicEvolving
public class TextFormatOptions {
    public static final ConfigOption<String> CHARSET = ConfigOptions.key((String)"format.charset").stringType().defaultValue((Object)"UTF-8").withDescription("Optional text encoding format ('utf-8' by default)");
    public static final ConfigOption<String> FIELD_DELIMITER = ConfigOptions.key((String)"format.field-delimiter").stringType().defaultValue((Object)String.valueOf(',')).withDescription("Optional field delimiter character (',' by default)");
    public static final ConfigOption<String> QUOTE_CHARACTER = ConfigOptions.key((String)"format.quote-character").stringType().defaultValue((Object)String.valueOf(TableFormatConstants.DEFAULT_QUOTE_CHARACTER)).withDescription("Optional quote character for enclosing field values ('\"' by default)");
    public static final ConfigOption<String> ESCAPE_CHARACTER = ConfigOptions.key((String)"format.escape-character").stringType().defaultValue((Object)String.valueOf(TableFormatConstants.DEFAULT_ESCAPE_CHARACTER)).withDescription("Optional escape character for escaping values (disabled by default)");
    public static final ConfigOption<String> NULL_LITERAL = ConfigOptions.key((String)"format.null-literal").stringType().defaultValue((Object)"format.null-literal").withDescription("Optional null literal string that is interpreted as a\nnull value (disabled by default)");
    public static final ConfigOption<String> KV_ENTRY_DELIMITER = ConfigOptions.key((String)"format.entry-delimiter").stringType().defaultValue((Object)String.valueOf('&'));
    public static final ConfigOption<String> KV_DELIMITER = ConfigOptions.key((String)"format.kv-delimiter").stringType().defaultValue((Object)String.valueOf('='));
    public static final ConfigOption<String> LINE_DELIMITER = ConfigOptions.key((String)"format.line-delimiter").stringType().defaultValue((Object)String.valueOf(TableFormatConstants.DEFAULT_LINE_DELIMITER));
    public static final ConfigOption<String> FORMAT_PROPERTIES = ConfigOptions.key((String)"properties").stringType().noDefaultValue();
    public static final ConfigOption<String> MAP_NULL_KEY_MODE = ConfigOptions.key((String)"map-null-key.mode").stringType().defaultValue((Object)"FAIL").withDescription("Optional flag to control the handling mode when serializing null key for map data, FAIL by default. Option DROP will drop null key entries for map data. Option LITERAL will use 'map-null-key.literal' as key literal.");
    public static final ConfigOption<Boolean> FAIL_ON_MISSING_FIELD = ConfigOptions.key((String)"fail-on-missing-field").booleanType().defaultValue((Object)false).withDescription("Optional flag to specify whether to fail if a field is missing or not, false by default.");
    public static final ConfigOption<String> MAP_NULL_KEY_LITERAL = ConfigOptions.key((String)"map-null-key.literal").stringType().defaultValue((Object)"null").withDescription("Optional flag to specify string literal for null keys when 'map-null-key.mode' is LITERAL, \"null\" by default.");
    public static final ConfigOption<String> TIMESTAMP_FORMAT = ConfigOptions.key((String)"timestamp-format.standard").stringType().defaultValue((Object)"SQL").withDescription("Optional flag to specify timestamp format, SQL by default. Option ISO-8601 will parse input timestamp in \"yyyy-MM-ddTHH:mm:ss.s{precision}\" format and output timestamp in the same format. Option SQL will parse input timestamp in \"yyyy-MM-dd HH:mm:ss.s{precision}\" format and output timestamp in the same format.");

    private TextFormatOptions() {
    }

    public static enum TimestampFormat {
        SQL,
        ISO_8601;

    }

    public static enum MapNullKeyMode {
        FAIL,
        DROP,
        LITERAL;

    }
}

