/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.deparser;

import java.util.Iterator;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.ItemsListVisitor;
import net.sf.jsqlparser.expression.operators.relational.MultiExpressionList;
import net.sf.jsqlparser.expression.operators.relational.NamedExpressionList;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.select.WithItem;
import net.sf.jsqlparser.statement.upsert.Upsert;
import net.sf.jsqlparser.statement.upsert.UpsertType;
import net.sf.jsqlparser.util.deparser.AbstractDeParser;

public class UpsertDeParser
extends AbstractDeParser<Upsert>
implements ItemsListVisitor {
    private ExpressionVisitor expressionVisitor;
    private SelectVisitor selectVisitor;

    public UpsertDeParser(ExpressionVisitor expressionVisitor, SelectVisitor selectVisitor, StringBuilder buffer) {
        super(buffer);
        this.expressionVisitor = expressionVisitor;
        this.selectVisitor = selectVisitor;
    }

    @Override
    public void deParse(Upsert upsert) {
        switch (upsert.getUpsertType()) {
            case REPLACE: 
            case REPLACE_SET: {
                this.buffer.append("REPLACE ");
                break;
            }
            case INSERT_OR_ABORT: {
                this.buffer.append("INSERT OR ABORT ");
                break;
            }
            case INSERT_OR_FAIL: {
                this.buffer.append("INSERT OR FAIL ");
                break;
            }
            case INSERT_OR_IGNORE: {
                this.buffer.append("INSERT OR IGNORE ");
                break;
            }
            case INSERT_OR_REPLACE: {
                this.buffer.append("INSERT OR REPLACE ");
                break;
            }
            case INSERT_OR_ROLLBACK: {
                this.buffer.append("INSERT OR ROLLBACK ");
                break;
            }
            default: {
                this.buffer.append("UPSERT ");
            }
        }
        if (upsert.isUsingInto()) {
            this.buffer.append("INTO ");
        }
        this.buffer.append(upsert.getTable().getFullyQualifiedName());
        if (upsert.getUpsertType() == UpsertType.REPLACE_SET) {
            this.appendReplaceSetClause(upsert);
        } else {
            if (upsert.getColumns() != null) {
                this.appendColumns(upsert);
            }
            if (upsert.getItemsList() != null) {
                upsert.getItemsList().accept(this);
            }
            if (upsert.getSelect() != null) {
                this.appendSelect(upsert);
            }
            if (upsert.isUseDuplicate()) {
                this.appendDuplicate(upsert);
            }
        }
    }

    private void appendReplaceSetClause(Upsert upsert) {
        this.buffer.append(" SET ");
        List<Expression> expressions = upsert.getSetExpressions();
        int s = upsert.getColumns().size();
        for (int i = 0; i < s; ++i) {
            this.buffer.append(upsert.getColumns().get(i)).append("=").append(expressions.get(i));
            this.buffer.append(i < s - 1 ? ", " : "");
        }
    }

    private void appendColumns(Upsert upsert) {
        this.buffer.append(" (");
        Iterator<Column> iter = upsert.getColumns().iterator();
        while (iter.hasNext()) {
            Column column = iter.next();
            this.buffer.append(column.getColumnName());
            if (!iter.hasNext()) continue;
            this.buffer.append(", ");
        }
        this.buffer.append(")");
    }

    private void appendSelect(Upsert upsert) {
        this.buffer.append(" ");
        if (upsert.isUseSelectBrackets()) {
            this.buffer.append("(");
        }
        if (upsert.getSelect().getWithItemsList() != null) {
            this.buffer.append("WITH ");
            for (WithItem with : upsert.getSelect().getWithItemsList()) {
                with.accept(this.selectVisitor);
            }
            this.buffer.append(" ");
        }
        upsert.getSelect().getSelectBody().accept(this.selectVisitor);
        if (upsert.isUseSelectBrackets()) {
            this.buffer.append(")");
        }
    }

    private void appendDuplicate(Upsert upsert) {
        this.buffer.append(" ON DUPLICATE KEY UPDATE ");
        for (int i = 0; i < upsert.getDuplicateUpdateColumns().size(); ++i) {
            Column column = upsert.getDuplicateUpdateColumns().get(i);
            this.buffer.append(column.getFullyQualifiedName()).append(" = ");
            Expression expression = upsert.getDuplicateUpdateExpressionList().get(i);
            expression.accept(this.expressionVisitor);
            if (i >= upsert.getDuplicateUpdateColumns().size() - 1) continue;
            this.buffer.append(", ");
        }
    }

    @Override
    public void visit(ExpressionList expressionList) {
        this.buffer.append(" VALUES (");
        Iterator<Expression> iter = expressionList.getExpressions().iterator();
        while (iter.hasNext()) {
            Expression expression = iter.next();
            expression.accept(this.expressionVisitor);
            if (!iter.hasNext()) continue;
            this.buffer.append(", ");
        }
        this.buffer.append(")");
    }

    @Override
    public void visit(NamedExpressionList namedExpressionList) {
    }

    @Override
    public void visit(MultiExpressionList multiExprList) {
        this.buffer.append(" VALUES ");
        Iterator<ExpressionList> it = multiExprList.getExprList().iterator();
        while (it.hasNext()) {
            this.buffer.append("(");
            Iterator<Expression> iter = it.next().getExpressions().iterator();
            while (iter.hasNext()) {
                Expression expression = iter.next();
                expression.accept(this.expressionVisitor);
                if (!iter.hasNext()) continue;
                this.buffer.append(", ");
            }
            this.buffer.append(")");
            if (!it.hasNext()) continue;
            this.buffer.append(", ");
        }
    }

    @Override
    public void visit(SubSelect subSelect) {
        subSelect.getSelectBody().accept(this.selectVisitor);
    }

    public ExpressionVisitor getExpressionVisitor() {
        return this.expressionVisitor;
    }

    public SelectVisitor getSelectVisitor() {
        return this.selectVisitor;
    }

    public void setExpressionVisitor(ExpressionVisitor visitor) {
        this.expressionVisitor = visitor;
    }

    public void setSelectVisitor(SelectVisitor visitor) {
        this.selectVisitor = visitor;
    }
}

