/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.node;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.text.StringSubstitutor;
import org.apache.commons.text.lookup.StringLookup;
import org.apache.commons.text.lookup.StringLookupFactory;

final class MapResolver {
    private static final String PROPS_IMPL_KEY = "propertiesImplementation";
    private static final String ENV_VAR_PROPERTY = "org.apache.flume.node.EnvVarResolverProperties";

    MapResolver() {
    }

    public static Map<String, String> resolveProperties(Properties properties) {
        HashMap<String, String> map = new HashMap<String, String>();
        boolean useEnvVars = ENV_VAR_PROPERTY.equals(System.getProperty(PROPS_IMPL_KEY));
        DefaultLookup defaultLookup = useEnvVars ? new DefaultLookup(map) : StringLookupFactory.INSTANCE.mapStringLookup(map);
        StringLookup lookup = StringLookupFactory.INSTANCE.interpolatorStringLookup((StringLookup)defaultLookup);
        StringSubstitutor substitutor = new StringSubstitutor(lookup);
        substitutor.setEnableSubstitutionInVariables(true);
        properties.stringPropertyNames().forEach(k -> map.put((String)k, substitutor.replace(properties.getProperty((String)k))));
        return map;
    }

    private static class DefaultLookup
    implements StringLookup {
        private final Map<String, String> properties;

        DefaultLookup(Map<String, String> properties) {
            this.properties = properties;
        }

        public String lookup(String key) {
            return this.properties.containsKey(key) ? this.properties.get(key) : System.getenv(key);
        }
    }
}

