/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.source.coordinator;

import java.io.IOException;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.function.BiConsumer;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.connector.source.ReaderInfo;
import org.apache.flink.api.connector.source.SourceEvent;
import org.apache.flink.api.connector.source.SourceSplit;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.api.connector.source.SplitsAssignment;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.metrics.groups.SplitEnumeratorMetricGroup;
import org.apache.flink.runtime.operators.coordination.ComponentClosingUtils;
import org.apache.flink.runtime.operators.coordination.OperatorCoordinator;
import org.apache.flink.runtime.operators.coordination.OperatorEvent;
import org.apache.flink.runtime.source.coordinator.ExecutorNotifier;
import org.apache.flink.runtime.source.coordinator.SourceCoordinatorProvider;
import org.apache.flink.runtime.source.coordinator.SplitAssignmentTracker;
import org.apache.flink.runtime.source.event.AddSplitEvent;
import org.apache.flink.runtime.source.event.NoMoreSplitsEvent;
import org.apache.flink.runtime.source.event.SourceEventWrapper;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.ThrowableCatchingRunnable;
import org.apache.flink.util.concurrent.ExecutorThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class SourceCoordinatorContext<SplitT extends SourceSplit>
implements SplitEnumeratorContext<SplitT>,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(SourceCoordinatorContext.class);
    private final ScheduledExecutorService workerExecutor;
    private final ScheduledExecutorService coordinatorExecutor;
    private final ExecutorNotifier notifier;
    private final OperatorCoordinator.Context operatorCoordinatorContext;
    private final SimpleVersionedSerializer<SplitT> splitSerializer;
    private final ConcurrentMap<Integer, ReaderInfo> registeredReaders;
    private final SplitAssignmentTracker<SplitT> assignmentTracker;
    private final SourceCoordinatorProvider.CoordinatorExecutorThreadFactory coordinatorThreadFactory;
    private final OperatorCoordinator.SubtaskGateway[] subtaskGateways;
    private final String coordinatorThreadName;
    private volatile boolean closed;

    public SourceCoordinatorContext(SourceCoordinatorProvider.CoordinatorExecutorThreadFactory coordinatorThreadFactory, int numWorkerThreads, OperatorCoordinator.Context operatorCoordinatorContext, SimpleVersionedSerializer<SplitT> splitSerializer) {
        this(Executors.newScheduledThreadPool(1, coordinatorThreadFactory), Executors.newScheduledThreadPool(numWorkerThreads, (ThreadFactory)new ExecutorThreadFactory(coordinatorThreadFactory.getCoordinatorThreadName() + "-worker")), coordinatorThreadFactory, operatorCoordinatorContext, splitSerializer, new SplitAssignmentTracker());
    }

    @VisibleForTesting
    SourceCoordinatorContext(ScheduledExecutorService coordinatorExecutor, ScheduledExecutorService workerExecutor, SourceCoordinatorProvider.CoordinatorExecutorThreadFactory coordinatorThreadFactory, OperatorCoordinator.Context operatorCoordinatorContext, SimpleVersionedSerializer<SplitT> splitSerializer, SplitAssignmentTracker<SplitT> splitAssignmentTracker) {
        this.workerExecutor = workerExecutor;
        this.coordinatorExecutor = coordinatorExecutor;
        this.coordinatorThreadFactory = coordinatorThreadFactory;
        this.operatorCoordinatorContext = operatorCoordinatorContext;
        this.splitSerializer = splitSerializer;
        this.registeredReaders = new ConcurrentHashMap<Integer, ReaderInfo>();
        this.assignmentTracker = splitAssignmentTracker;
        this.coordinatorThreadName = coordinatorThreadFactory.getCoordinatorThreadName();
        this.subtaskGateways = new OperatorCoordinator.SubtaskGateway[operatorCoordinatorContext.currentParallelism()];
        Executor errorHandlingCoordinatorExecutor = runnable -> coordinatorExecutor.execute((Runnable)new ThrowableCatchingRunnable(this::handleUncaughtExceptionFromAsyncCall, runnable));
        this.notifier = new ExecutorNotifier(workerExecutor, errorHandlingCoordinatorExecutor);
    }

    public SplitEnumeratorMetricGroup metricGroup() {
        return null;
    }

    public void sendEventToSourceReader(int subtaskId, SourceEvent event) {
        this.checkSubtaskIndex(subtaskId);
        this.callInCoordinatorThread(() -> {
            OperatorCoordinator.SubtaskGateway gateway = this.getGatewayAndCheckReady(subtaskId);
            gateway.sendEvent(new SourceEventWrapper(event));
            return null;
        }, String.format("Failed to send event %s to subtask %d", event, subtaskId));
    }

    void sendEventToSourceOperator(int subtaskId, OperatorEvent event) {
        this.checkSubtaskIndex(subtaskId);
        this.callInCoordinatorThread(() -> {
            OperatorCoordinator.SubtaskGateway gateway = this.getGatewayAndCheckReady(subtaskId);
            gateway.sendEvent(event);
            return null;
        }, String.format("Failed to send event %s to subtask %d", event, subtaskId));
    }

    ScheduledExecutorService getCoordinatorExecutor() {
        return this.coordinatorExecutor;
    }

    public int currentParallelism() {
        return this.operatorCoordinatorContext.currentParallelism();
    }

    public Map<Integer, ReaderInfo> registeredReaders() {
        return Collections.unmodifiableMap(this.registeredReaders);
    }

    public void assignSplits(SplitsAssignment<SplitT> assignment) {
        this.callInCoordinatorThread(() -> {
            assignment.assignment().forEach((id, splits) -> {
                if (!this.registeredReaders.containsKey(id)) {
                    throw new IllegalArgumentException(String.format("Cannot assign splits %s to subtask %d because the subtask is not registered.", splits, id));
                }
            });
            this.assignmentTracker.recordSplitAssignment(assignment);
            assignment.assignment().forEach((id, splits) -> {
                AddSplitEvent<SplitT> addSplitEvent;
                OperatorCoordinator.SubtaskGateway gateway = this.getGatewayAndCheckReady((int)id);
                try {
                    addSplitEvent = new AddSplitEvent<SplitT>(splits, this.splitSerializer);
                }
                catch (IOException e) {
                    throw new FlinkRuntimeException("Failed to serialize splits.", (Throwable)e);
                }
                gateway.sendEvent(addSplitEvent);
            });
            return null;
        }, String.format("Failed to assign splits %s due to ", assignment));
    }

    public void signalNoMoreSplits(int subtask) {
        this.checkSubtaskIndex(subtask);
        this.callInCoordinatorThread(() -> {
            OperatorCoordinator.SubtaskGateway gateway = this.getGatewayAndCheckReady(subtask);
            gateway.sendEvent(new NoMoreSplitsEvent());
            return null;
        }, "Failed to send 'NoMoreSplits' to reader " + subtask);
    }

    public <T> void callAsync(Callable<T> callable, BiConsumer<T, Throwable> handler, long initialDelay, long period) {
        this.notifier.notifyReadyAsync(callable, handler, initialDelay, period);
    }

    public <T> void callAsync(Callable<T> callable, BiConsumer<T, Throwable> handler) {
        this.notifier.notifyReadyAsync(callable, handler);
    }

    public void runInCoordinatorThread(Runnable runnable) {
        this.coordinatorExecutor.execute((Runnable)new ThrowableCatchingRunnable(throwable -> this.coordinatorThreadFactory.uncaughtException(Thread.currentThread(), (Throwable)throwable), runnable));
    }

    @Override
    public void close() throws InterruptedException {
        this.closed = true;
        ComponentClosingUtils.shutdownExecutorForcefully(this.workerExecutor, Duration.ofNanos(Long.MAX_VALUE));
        ComponentClosingUtils.shutdownExecutorForcefully(this.coordinatorExecutor, Duration.ofNanos(Long.MAX_VALUE));
    }

    void subtaskReady(OperatorCoordinator.SubtaskGateway gateway) {
        int subtask = gateway.getSubtask();
        if (this.subtaskGateways[subtask] != null) {
            throw new IllegalStateException("Already have a subtask gateway for " + subtask);
        }
        this.subtaskGateways[gateway.getSubtask()] = gateway;
    }

    void subtaskNotReady(int subtaskIndex) {
        this.subtaskGateways[subtaskIndex] = null;
    }

    OperatorCoordinator.SubtaskGateway getGatewayAndCheckReady(int subtaskIndex) {
        OperatorCoordinator.SubtaskGateway gateway = this.subtaskGateways[subtaskIndex];
        if (gateway != null) {
            return gateway;
        }
        throw new IllegalStateException(String.format("Subtask %d is not ready yet to receive events.", subtaskIndex));
    }

    void failJob(Throwable cause) {
        this.operatorCoordinatorContext.failJob(cause);
    }

    void handleUncaughtExceptionFromAsyncCall(Throwable t) {
        if (this.closed) {
            return;
        }
        ExceptionUtils.rethrowIfFatalErrorOrOOM((Throwable)t);
        LOG.error("Exception while handling result from async call in {}. Triggering job failover.", (Object)this.coordinatorThreadName, (Object)t);
        this.failJob(t);
    }

    void onCheckpoint(long checkpointId) throws Exception {
        this.assignmentTracker.onCheckpoint(checkpointId);
    }

    void registerSourceReader(ReaderInfo readerInfo) {
        ReaderInfo previousReader = this.registeredReaders.put(readerInfo.getSubtaskId(), readerInfo);
        if (previousReader != null) {
            throw new IllegalStateException("Overwriting " + previousReader + " with " + readerInfo);
        }
    }

    void unregisterSourceReader(int subtaskId) {
        this.registeredReaders.remove(subtaskId);
    }

    List<SplitT> getAndRemoveUncheckpointedAssignment(int subtaskId, long restoredCheckpointId) {
        return this.assignmentTracker.getAndRemoveUncheckpointedAssignment(subtaskId, restoredCheckpointId);
    }

    void onCheckpointComplete(long checkpointId) {
        this.assignmentTracker.onCheckpointComplete(checkpointId);
    }

    OperatorCoordinator.Context getCoordinatorContext() {
        return this.operatorCoordinatorContext;
    }

    private void checkSubtaskIndex(int subtaskIndex) {
        if (subtaskIndex < 0 || subtaskIndex >= this.getCoordinatorContext().currentParallelism()) {
            throw new IllegalArgumentException(String.format("Subtask index %d is out of bounds [0, %s)", subtaskIndex, this.getCoordinatorContext().currentParallelism()));
        }
    }

    private <V> V callInCoordinatorThread(Callable<V> callable, String errorMessage) {
        if (!this.coordinatorThreadFactory.isCurrentThreadCoordinatorThread()) {
            try {
                Callable<Object> guardedCallable = () -> {
                    try {
                        return callable.call();
                    }
                    catch (Throwable t) {
                        LOG.error("Uncaught Exception in Source Coordinator Executor", t);
                        ExceptionUtils.rethrowException((Throwable)t);
                        return null;
                    }
                };
                return (V)this.coordinatorExecutor.submit(guardedCallable).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new FlinkRuntimeException(errorMessage, (Throwable)e);
            }
        }
        try {
            return callable.call();
        }
        catch (Throwable t) {
            LOG.error("Uncaught Exception in Source Coordinator Executor", t);
            throw new FlinkRuntimeException(errorMessage, t);
        }
    }
}

