/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.executiongraph.AccessExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.AccessExecutionVertex;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.job.AbstractAccessExecutionGraphHandler;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rest.handler.util.MutableIOMetrics;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.JobMessageParameters;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.job.JobDetailsInfo;
import org.apache.flink.runtime.rest.messages.job.metrics.IOMetricsInfo;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.history.ArchivedJson;
import org.apache.flink.runtime.webmonitor.history.OnlyExecutionGraphJsonArchivist;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.util.Preconditions;

public class JobDetailsHandler
extends AbstractAccessExecutionGraphHandler<JobDetailsInfo, JobMessageParameters>
implements OnlyExecutionGraphJsonArchivist {
    private final MetricFetcher metricFetcher;

    public JobDetailsHandler(GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> responseHeaders, MessageHeaders<EmptyRequestBody, JobDetailsInfo, JobMessageParameters> messageHeaders, ExecutionGraphCache executionGraphCache, Executor executor, MetricFetcher metricFetcher) {
        super(leaderRetriever, timeout, responseHeaders, messageHeaders, executionGraphCache, executor);
        this.metricFetcher = (MetricFetcher)Preconditions.checkNotNull((Object)metricFetcher);
    }

    @Override
    protected JobDetailsInfo handleRequest(HandlerRequest<EmptyRequestBody> request, AccessExecutionGraph executionGraph) throws RestHandlerException {
        return JobDetailsHandler.createJobDetailsInfo(executionGraph, this.metricFetcher);
    }

    @Override
    public Collection<ArchivedJson> archiveJsonWithPath(AccessExecutionGraph graph) throws IOException {
        JobDetailsInfo json = JobDetailsHandler.createJobDetailsInfo(graph, null);
        String path = this.getMessageHeaders().getTargetRestEndpointURL().replace(":jobid", graph.getJobID().toString());
        return Collections.singleton(new ArchivedJson(path, json));
    }

    private static JobDetailsInfo createJobDetailsInfo(AccessExecutionGraph executionGraph, @Nullable MetricFetcher metricFetcher) {
        long now = System.currentTimeMillis();
        long startTime = executionGraph.getStatusTimestamp(JobStatus.INITIALIZING);
        long endTime = executionGraph.getState().isGloballyTerminalState() ? executionGraph.getStatusTimestamp(executionGraph.getState()) : -1L;
        long duration = (endTime > 0L ? endTime : now) - startTime;
        HashMap<JobStatus, Long> timestamps = new HashMap<JobStatus, Long>(JobStatus.values().length);
        for (JobStatus jobStatus : JobStatus.values()) {
            timestamps.put(jobStatus, executionGraph.getStatusTimestamp(jobStatus));
        }
        ArrayList<JobDetailsInfo.JobVertexDetailsInfo> jobVertexInfos = new ArrayList<JobDetailsInfo.JobVertexDetailsInfo>(executionGraph.getAllVertices().size());
        int[] jobVerticesPerState = new int[ExecutionState.values().length];
        for (AccessExecutionJobVertex accessExecutionJobVertex : executionGraph.getVerticesTopologically()) {
            JobDetailsInfo.JobVertexDetailsInfo vertexDetailsInfo = JobDetailsHandler.createJobVertexDetailsInfo(accessExecutionJobVertex, now, executionGraph.getJobID(), metricFetcher);
            jobVertexInfos.add(vertexDetailsInfo);
            int n = vertexDetailsInfo.getExecutionState().ordinal();
            jobVerticesPerState[n] = jobVerticesPerState[n] + 1;
        }
        HashMap<ExecutionState, Integer> jobVerticesPerStateMap = new HashMap<ExecutionState, Integer>(ExecutionState.values().length);
        for (ExecutionState executionState : ExecutionState.values()) {
            jobVerticesPerStateMap.put(executionState, jobVerticesPerState[executionState.ordinal()]);
        }
        return new JobDetailsInfo(executionGraph.getJobID(), executionGraph.getJobName(), executionGraph.isStoppable(), executionGraph.getState(), startTime, endTime, duration, executionGraph.getArchivedExecutionConfig().getMaxParallelism(), now, timestamps, jobVertexInfos, jobVerticesPerStateMap, executionGraph.getJsonPlan());
    }

    private static JobDetailsInfo.JobVertexDetailsInfo createJobVertexDetailsInfo(AccessExecutionJobVertex ejv, long now, JobID jobId, MetricFetcher metricFetcher) {
        long duration;
        int[] tasksPerState = new int[ExecutionState.values().length];
        long startTime = Long.MAX_VALUE;
        long endTime = 0L;
        boolean allFinished = true;
        for (AccessExecutionVertex vertex : ejv.getTaskVertices()) {
            ExecutionState[] state = vertex.getExecutionState();
            int n = state.ordinal();
            tasksPerState[n] = tasksPerState[n] + 1;
            long started = vertex.getStateTimestamp(ExecutionState.DEPLOYING);
            if (started > 0L) {
                startTime = Math.min(startTime, started);
            }
            allFinished &= state.isTerminal();
            endTime = Math.max(endTime, vertex.getStateTimestamp((ExecutionState)state));
        }
        if (startTime < Long.MAX_VALUE) {
            if (allFinished) {
                duration = endTime - startTime;
            } else {
                endTime = -1L;
                duration = now - startTime;
            }
        } else {
            startTime = -1L;
            endTime = -1L;
            duration = -1L;
        }
        ExecutionState jobVertexState = ExecutionJobVertex.getAggregateJobVertexState(tasksPerState, ejv.getParallelism());
        HashMap<ExecutionState, Integer> tasksPerStateMap = new HashMap<ExecutionState, Integer>(tasksPerState.length);
        for (ExecutionState executionState : ExecutionState.values()) {
            tasksPerStateMap.put(executionState, tasksPerState[executionState.ordinal()]);
        }
        MutableIOMetrics counts = new MutableIOMetrics();
        for (AccessExecutionVertex vertex : ejv.getTaskVertices()) {
            counts.addIOMetrics(vertex.getCurrentExecutionAttempt(), metricFetcher, jobId.toString(), ejv.getJobVertexId().toString());
        }
        IOMetricsInfo jobVertexMetrics = new IOMetricsInfo(counts.getNumBytesIn(), counts.isNumBytesInComplete(), counts.getNumBytesOut(), counts.isNumBytesOutComplete(), counts.getNumRecordsIn(), counts.isNumRecordsInComplete(), counts.getNumRecordsOut(), counts.isNumRecordsOutComplete());
        return new JobDetailsInfo.JobVertexDetailsInfo(ejv.getJobVertexId(), ejv.getName(), ejv.getMaxParallelism(), ejv.getParallelism(), jobVertexState, startTime, endTime, duration, tasksPerStateMap, jobVertexMetrics);
    }
}

