/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.common.monitor;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.inlong.common.monitor.CounterGroup;
import org.apache.inlong.common.monitor.CounterGroupExt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatRunner
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(StatRunner.class);
    private boolean shutDownFlag = false;
    private String name;
    private CounterGroup counterGroup;
    private CounterGroupExt counterGroupExt;
    private int intervalSec;
    private Set<String> moniterNames;

    public StatRunner(String name, CounterGroup counterGroup, CounterGroupExt counterExt, int intervalSec, Set<String> moniterNames) {
        this.counterGroup = counterGroup;
        this.counterGroupExt = counterExt;
        this.intervalSec = intervalSec;
        this.moniterNames = moniterNames;
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        HashMap<String, Long> counters = new HashMap<String, Long>();
        HashMap<String, Long> counterExt = new HashMap<String, Long>();
        while (!this.shutDownFlag) {
            try {
                long cnt;
                Thread.sleep(this.intervalSec * 1000);
                for (String str : this.moniterNames) {
                    cnt = 0L;
                    CounterGroup counterGroup = this.counterGroup;
                    synchronized (counterGroup) {
                        cnt = this.counterGroup.get(str);
                        this.counterGroup.set(str, 0L);
                        counters.put(str, cnt);
                    }
                }
                for (String str : this.moniterNames) {
                    cnt = (Long)counters.get(str);
                    logger.info("{}.{}={}", new Object[]{this.name, str, cnt});
                }
                counters.clear();
                CounterGroupExt counterGroupExt = this.counterGroupExt;
                synchronized (counterGroupExt) {
                    Iterator<String> ite = this.counterGroupExt.getCounters().keySet().iterator();
                    while (true) {
                        String str;
                        if (!ite.hasNext()) break;
                        str = ite.next();
                        counterExt.put(str, this.counterGroupExt.get(str));
                    }
                    this.counterGroupExt.clear();
                }
                for (Map.Entry entry : counterExt.entrySet()) {
                    logger.info("{}.{}={}", new Object[]{this.name, entry.getKey(), entry.getValue()});
                }
                counterExt.clear();
            }
            catch (Exception var12) {
                logger.warn("statrunner interrupted");
            }
        }
    }

    public void shutDown() {
        this.shutDownFlag = true;
    }
}

