/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.common.enums;

import java.util.Locale;

public enum DataTypeEnum {
    CSV("csv"),
    KV("kv"),
    AVRO("avro"),
    JSON("json"),
    CANAL("canal"),
    DEBEZIUM_JSON("debezium_json"),
    RAW("raw"),
    TEXT("text"),
    PB("pb"),
    JCE("jce"),
    UNKNOWN("n");

    private final String type;

    private DataTypeEnum(String type) {
        this.type = type;
    }

    public static DataTypeEnum forType(String type) {
        for (DataTypeEnum dataType : DataTypeEnum.values()) {
            if (!dataType.getType().equals(type.toLowerCase(Locale.ROOT))) continue;
            return dataType;
        }
        throw new IllegalArgumentException("Unsupported data type for " + type);
    }

    public static DataTypeEnum convert(String value) {
        for (DataTypeEnum v : DataTypeEnum.values()) {
            if (!v.getType().equals(value.toLowerCase(Locale.ROOT))) continue;
            return v;
        }
        return UNKNOWN;
    }

    public String toString() {
        return this.name() + ":" + this.type;
    }

    public String getType() {
        return this.type;
    }
}

