/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql.legacy;

import com.github.shyiko.mysql.binlog.event.Event;
import com.github.shyiko.mysql.binlog.event.EventType;
import com.github.shyiko.mysql.binlog.event.QueryEventData;
import io.debezium.connector.mysql.legacy.BinlogReader;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EventBuffer {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventBuffer.class);
    private final int capacity;
    private final Queue<Event> buffer;
    private final BinlogReader reader;
    private boolean txStarted = false;
    private BinlogReader.BinlogPosition largeTxNotBufferedPosition;
    private BinlogReader.BinlogPosition forwardTillPosition;

    public EventBuffer(int capacity, BinlogReader reader) {
        this.capacity = capacity;
        this.buffer = new ArrayBlockingQueue<Event>(capacity);
        this.reader = reader;
    }

    public void add(Event event) {
        if (event == null) {
            return;
        }
        if (this.isReplayingEventsBeyondBufferCapacity()) {
            this.reader.handleEvent(event);
            return;
        }
        if (event.getHeader().getEventType() == EventType.QUERY) {
            QueryEventData command = (QueryEventData)this.reader.unwrapData(event);
            LOGGER.debug("Received query command: {}", (Object)event);
            String sql = command.getSql().trim();
            if (sql.equalsIgnoreCase("BEGIN")) {
                this.beginTransaction(event);
            } else if (sql.equalsIgnoreCase("COMMIT")) {
                this.completeTransaction(true, event);
            } else if (sql.equalsIgnoreCase("ROLLBACK")) {
                this.rollbackTransaction();
            } else {
                this.consumeEvent(event);
            }
        } else if (event.getHeader().getEventType() == EventType.XID) {
            this.completeTransaction(true, event);
        } else {
            this.consumeEvent(event);
        }
    }

    private boolean isReplayingEventsBeyondBufferCapacity() {
        if (this.forwardTillPosition != null) {
            if (this.forwardTillPosition.equals(this.reader.getCurrentBinlogPosition())) {
                this.forwardTillPosition = null;
            }
            return true;
        }
        return false;
    }

    private void addToBuffer(Event event) {
        if (this.isInBufferFullMode()) {
            return;
        }
        if (this.buffer.size() == this.capacity) {
            this.switchToBufferFullMode();
        } else {
            this.buffer.add(event);
        }
    }

    private void switchToBufferFullMode() {
        this.largeTxNotBufferedPosition = this.reader.getCurrentBinlogPosition();
        LOGGER.info("Buffer full, will need to re-read part of the transaction from binlog from {}", (Object)this.largeTxNotBufferedPosition);
        this.reader.getMetrics().onLargeTransaction();
        if (this.buffer.peek().getHeader().getEventType() == EventType.TABLE_MAP) {
            this.buffer.remove();
        }
    }

    private boolean isInBufferFullMode() {
        return this.largeTxNotBufferedPosition != null;
    }

    private void consumeEvent(Event event) {
        if (this.txStarted) {
            this.addToBuffer(event);
        } else {
            this.reader.handleEvent(event);
        }
    }

    private void beginTransaction(Event event) {
        if (this.txStarted) {
            LOGGER.warn("New transaction started but the previous was not completed, processing the buffer");
            this.completeTransaction(false, null);
        } else {
            this.txStarted = true;
        }
        this.addToBuffer(event);
    }

    private void completeTransaction(boolean wellFormed, Event event) {
        LOGGER.debug("Committing transaction");
        if (event != null) {
            this.addToBuffer(event);
        }
        if (!this.txStarted) {
            LOGGER.warn("Commit requested but TX was not started before");
            wellFormed = false;
        }
        LOGGER.debug("Executing events from buffer");
        for (Event e : this.buffer) {
            this.reader.handleEvent(e);
        }
        LOGGER.debug("Executing events from binlog that have not fit into buffer");
        if (this.isInBufferFullMode()) {
            this.forwardTillPosition = this.reader.getCurrentBinlogPosition();
            this.reader.rewindBinaryLogClient(this.largeTxNotBufferedPosition);
        }
        this.reader.getMetrics().onCommittedTransaction();
        if (!wellFormed) {
            this.reader.getMetrics().onNotWellFormedTransaction();
        }
        this.clear();
    }

    private void rollbackTransaction() {
        LOGGER.debug("Rolling back transaction");
        boolean wellFormed = true;
        if (!this.txStarted) {
            LOGGER.warn("Rollback requested but TX was not started before");
            wellFormed = false;
        }
        this.reader.getMetrics().onRolledBackTransaction();
        if (!wellFormed) {
            this.reader.getMetrics().onNotWellFormedTransaction();
        }
        this.clear();
    }

    private void clear() {
        this.buffer.clear();
        this.largeTxNotBufferedPosition = null;
        this.txStarted = false;
    }
}

