/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.service.sink;

import com.github.benmanes.caffeine.cache.Cache;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.inlong.audit.service.channel.DataQueue;
import org.apache.inlong.audit.service.config.Configuration;
import org.apache.inlong.audit.service.entities.StatData;
import org.apache.inlong.audit.service.sink.AuditSink;
import org.apache.inlong.audit.service.utils.CacheUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheSink
implements AuditSink {
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheSink.class);
    private final ScheduledExecutorService sinkTimer = Executors.newSingleThreadScheduledExecutor();
    private final DataQueue dataQueue;
    private final Cache<String, StatData> cache;
    private final int pullTimeOut;

    public CacheSink(DataQueue dataQueue, Cache<String, StatData> cache) {
        this.dataQueue = dataQueue;
        this.cache = cache;
        this.pullTimeOut = Configuration.getInstance().get("queue.pull.timeout.ms", 1000);
    }

    public void start() {
        this.sinkTimer.scheduleWithFixedDelay(() -> this.process(), 0L, Configuration.getInstance().get("sink.db.interval.ms", 100), TimeUnit.MILLISECONDS);
    }

    private void process() {
        try {
            StatData data = this.dataQueue.pull((long)this.pullTimeOut, TimeUnit.MILLISECONDS);
            while (data != null) {
                String cacheKey = CacheUtils.buildCacheKey((String)data.getLogTs(), (String)data.getInlongGroupId(), (String)data.getInlongStreamId(), (String)data.getAuditId(), (String)data.getAuditTag());
                this.cache.put((Object)cacheKey, (Object)data);
                data = this.dataQueue.pull((long)this.pullTimeOut, TimeUnit.MILLISECONDS);
            }
        }
        catch (Exception exception) {
            LOGGER.error("Process exception! ", (Throwable)exception);
        }
    }

    public void destroy() {
        this.sinkTimer.shutdown();
    }
}

