/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.service.node;

import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.net.InetSocketAddress;
import java.util.concurrent.Executors;
import org.apache.inlong.audit.service.cache.AuditProxyCache;
import org.apache.inlong.audit.service.config.Configuration;
import org.apache.inlong.audit.service.entities.ApiType;
import org.apache.inlong.audit.service.node.ApiService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiService.class);

    public void start() {
        if (!AuditProxyCache.getInstance().init()) {
            LOGGER.error("Audit Proxy cache init failed! exit...");
            System.exit(1);
        }
        this.initHttpServer();
    }

    public void stop() {
    }

    private void initHttpServer() {
        int bindPort = Configuration.getInstance().get("api.http.server.bind.port", 10080);
        try {
            HttpServer server = HttpServer.create(new InetSocketAddress(bindPort), Configuration.getInstance().get("api.backlog.size", 100));
            server.setExecutor(Executors.newFixedThreadPool(Configuration.getInstance().get("api.thread.pool.size", 10)));
            server.createContext(Configuration.getInstance().get("api.day.path", "/audit/query/day"), (HttpHandler)new AuditHandler(this, ApiType.DAY));
            server.createContext(Configuration.getInstance().get("api.hour.path", "/audit/query/hour"), (HttpHandler)new AuditHandler(this, ApiType.HOUR));
            server.createContext(Configuration.getInstance().get("api.minutes.path", "/audit/query/minutes"), (HttpHandler)new AuditHandler(this, ApiType.MINUTES));
            server.createContext(Configuration.getInstance().get("api.get.ids.path", "/audit/query/getIds"), (HttpHandler)new AuditHandler(this, ApiType.GET_IDS));
            server.createContext(Configuration.getInstance().get("api.get.ips.path", "/audit/query/getIps"), (HttpHandler)new AuditHandler(this, ApiType.GET_IPS));
            server.createContext(Configuration.getInstance().get("api.get.audit.proxy", "/audit/query/getAuditProxy"), (HttpHandler)new AuditHandler(this, ApiType.GET_AUDIT_PROXY));
            server.createContext(Configuration.getInstance().get("api.get.audit.proxy", "/audit/query/getAuditProxy"), (HttpHandler)new AuditHandler(this, ApiType.GET_AUDIT_PROXY));
            server.createContext(Configuration.getInstance().get("api.reconciliation.path", "/audit/query/reconciliation"), (HttpHandler)new AuditHandler(this, ApiType.RECONCILIATION));
            server.start();
            LOGGER.info("Init http server success. Bind port is: {}", (Object)bindPort);
        }
        catch (Exception e) {
            LOGGER.error("Init http server has exception!", (Throwable)e);
        }
    }

    static /* synthetic */ Logger access$200() {
        return LOGGER;
    }
}

