/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.inlong.dataproxy.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.inlong.sdk.dataproxy.exception.ProxyEventException;
import org.apache.inlong.sdk.dataproxy.utils.LogCounter;
import org.apache.inlong.sdk.dataproxy.utils.ProxyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EventInfo<T> {
    protected static final Logger logger = LoggerFactory.getLogger(EventInfo.class);
    protected static final LogCounter exceptCnt = new LogCounter(10L, 100000L, 60000L);
    private final String groupId;
    private final String streamId;
    private final long dtMs;
    private final Map<String, String> attrs = new HashMap<String, String>();
    protected int msgCnt = 0;
    protected int bodySize = 0;
    protected final List<T> bodyList = new ArrayList<T>();

    protected EventInfo(String groupId, String streamId, long dtMs, Long auditId, String msgUUID, Map<String, String> attrs, boolean isSingle, List<T> bodyList) throws ProxyEventException {
        if (StringUtils.isBlank(groupId)) {
            throw new ProxyEventException("groupId is blank!");
        }
        this.groupId = groupId.trim();
        if (StringUtils.isBlank(streamId)) {
            throw new ProxyEventException("streamId is blank!");
        }
        this.streamId = streamId.trim();
        long l = this.dtMs = dtMs <= 0L ? System.currentTimeMillis() : dtMs;
        if (attrs != null && !attrs.isEmpty()) {
            for (Map.Entry<String, String> entry : attrs.entrySet()) {
                if (StringUtils.isBlank(entry.getKey())) continue;
                this.innSetAttr(entry.getKey().trim(), entry.getValue());
            }
        }
        if (auditId != null && auditId != -1L) {
            this.attrs.put("auditVersion", String.valueOf(auditId));
        }
        if (StringUtils.isNotBlank(msgUUID)) {
            this.attrs.put("msgUUID", msgUUID.trim());
        }
        this.setBodyList(isSingle, bodyList);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getStreamId() {
        return this.streamId;
    }

    public long getDtMs() {
        return this.dtMs;
    }

    public Map<String, String> getAttrs() {
        return this.attrs;
    }

    public int getMsgCnt() {
        return this.msgCnt;
    }

    public int getBodySize() {
        return this.bodySize;
    }

    protected abstract void setBodyList(boolean var1, List<T> var2) throws ProxyEventException;

    protected void innSetAttr(String key, String value) throws ProxyEventException {
        if (ProxyUtils.SdkReservedWords.contains(key)) {
            throw new ProxyEventException("Attribute key(" + key + ") is reserved word!");
        }
        if (key.contains("&") || key.contains("=")) {
            if (exceptCnt.shouldPrint()) {
                logger.warn(String.format("Attribute key(%s) include reserved word(%s or %s)", key, "=", "="));
            }
            throw new ProxyEventException("Attribute key(" + key + ") include reserved word(" + "=" + " or " + "=" + ")!");
        }
        String valValue = value;
        if (valValue != null && ((valValue = valValue.trim()).contains("&") || valValue.contains("="))) {
            if (exceptCnt.shouldPrint()) {
                logger.warn(String.format("Attribute value(%s) include reserved word(%s or %s)", valValue, "=", "="));
            }
            throw new ProxyEventException("Attribute value(" + valValue + ") include reserved word(" + "=" + " or " + "=" + ")!");
        }
        this.attrs.put(key, valValue);
    }
}

