/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.source.hudi;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.List;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonTypeDefine;
import org.apache.inlong.manager.pojo.source.SourceRequest;
import org.apache.inlong.manager.pojo.source.StreamSource;
import org.apache.inlong.manager.pojo.source.hudi.HudiSourceRequest;

@ApiModel(value="Hudi source info")
@JsonTypeDefine(value="HUDI")
public class HudiSource
extends StreamSource {
    @ApiModelProperty(value="The database name of Hudi")
    private String dbName;
    @ApiModelProperty(value="The table name of the Hudi")
    private String tableName;
    @ApiModelProperty(value="The catalog uri of the Hudi")
    private String catalogUri;
    @ApiModelProperty(value="The dfs base path of the Hudi")
    private String warehouse;
    @ApiModelProperty(value="The check file interval in minutes")
    private int checkIntervalInMinus;
    @ApiModelProperty(value="The flag indicate whether skip files in compaction")
    private boolean readStreamingSkipCompaction;
    @ApiModelProperty(value="The start commit id")
    private String readStartCommit;
    @ApiModelProperty(value="Extended properties")
    private List<HashMap<String, String>> extList;

    public HudiSource() {
        this.setSourceType("HUDI");
    }

    @Override
    public SourceRequest genSourceRequest() {
        return (SourceRequest)CommonBeanUtils.copyProperties((Object)this, HudiSourceRequest::new);
    }

    protected HudiSource(HudiSourceBuilder<?, ?> b) {
        super((StreamSource.StreamSourceBuilder<?, ?>)b);
        this.dbName = ((HudiSourceBuilder)b).dbName;
        this.tableName = ((HudiSourceBuilder)b).tableName;
        this.catalogUri = ((HudiSourceBuilder)b).catalogUri;
        this.warehouse = ((HudiSourceBuilder)b).warehouse;
        this.checkIntervalInMinus = ((HudiSourceBuilder)b).checkIntervalInMinus;
        this.readStreamingSkipCompaction = ((HudiSourceBuilder)b).readStreamingSkipCompaction;
        this.readStartCommit = ((HudiSourceBuilder)b).readStartCommit;
        this.extList = ((HudiSourceBuilder)b).extList;
    }

    public static HudiSourceBuilder<?, ?> builder() {
        return new HudiSourceBuilderImpl();
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getCatalogUri() {
        return this.catalogUri;
    }

    public String getWarehouse() {
        return this.warehouse;
    }

    public int getCheckIntervalInMinus() {
        return this.checkIntervalInMinus;
    }

    public boolean isReadStreamingSkipCompaction() {
        return this.readStreamingSkipCompaction;
    }

    public String getReadStartCommit() {
        return this.readStartCommit;
    }

    public List<HashMap<String, String>> getExtList() {
        return this.extList;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setCatalogUri(String catalogUri) {
        this.catalogUri = catalogUri;
    }

    public void setWarehouse(String warehouse) {
        this.warehouse = warehouse;
    }

    public void setCheckIntervalInMinus(int checkIntervalInMinus) {
        this.checkIntervalInMinus = checkIntervalInMinus;
    }

    public void setReadStreamingSkipCompaction(boolean readStreamingSkipCompaction) {
        this.readStreamingSkipCompaction = readStreamingSkipCompaction;
    }

    public void setReadStartCommit(String readStartCommit) {
        this.readStartCommit = readStartCommit;
    }

    public void setExtList(List<HashMap<String, String>> extList) {
        this.extList = extList;
    }

    public HudiSource(String dbName, String tableName, String catalogUri, String warehouse, int checkIntervalInMinus, boolean readStreamingSkipCompaction, String readStartCommit, List<HashMap<String, String>> extList) {
        this.dbName = dbName;
        this.tableName = tableName;
        this.catalogUri = catalogUri;
        this.warehouse = warehouse;
        this.checkIntervalInMinus = checkIntervalInMinus;
        this.readStreamingSkipCompaction = readStreamingSkipCompaction;
        this.readStartCommit = readStartCommit;
        this.extList = extList;
    }

    @Override
    public String toString() {
        return "HudiSource(super=" + super.toString() + ", dbName=" + this.getDbName() + ", tableName=" + this.getTableName() + ", catalogUri=" + this.getCatalogUri() + ", warehouse=" + this.getWarehouse() + ", checkIntervalInMinus=" + this.getCheckIntervalInMinus() + ", readStreamingSkipCompaction=" + this.isReadStreamingSkipCompaction() + ", readStartCommit=" + this.getReadStartCommit() + ", extList=" + this.getExtList() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HudiSource)) {
            return false;
        }
        HudiSource other = (HudiSource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getCheckIntervalInMinus() != other.getCheckIntervalInMinus()) {
            return false;
        }
        if (this.isReadStreamingSkipCompaction() != other.isReadStreamingSkipCompaction()) {
            return false;
        }
        String this$dbName = this.getDbName();
        String other$dbName = other.getDbName();
        if (this$dbName == null ? other$dbName != null : !this$dbName.equals(other$dbName)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$catalogUri = this.getCatalogUri();
        String other$catalogUri = other.getCatalogUri();
        if (this$catalogUri == null ? other$catalogUri != null : !this$catalogUri.equals(other$catalogUri)) {
            return false;
        }
        String this$warehouse = this.getWarehouse();
        String other$warehouse = other.getWarehouse();
        if (this$warehouse == null ? other$warehouse != null : !this$warehouse.equals(other$warehouse)) {
            return false;
        }
        String this$readStartCommit = this.getReadStartCommit();
        String other$readStartCommit = other.getReadStartCommit();
        if (this$readStartCommit == null ? other$readStartCommit != null : !this$readStartCommit.equals(other$readStartCommit)) {
            return false;
        }
        List<HashMap<String, String>> this$extList = this.getExtList();
        List<HashMap<String, String>> other$extList = other.getExtList();
        return !(this$extList == null ? other$extList != null : !((Object)this$extList).equals(other$extList));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof HudiSource;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getCheckIntervalInMinus();
        result = result * 59 + (this.isReadStreamingSkipCompaction() ? 79 : 97);
        String $dbName = this.getDbName();
        result = result * 59 + ($dbName == null ? 43 : $dbName.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $catalogUri = this.getCatalogUri();
        result = result * 59 + ($catalogUri == null ? 43 : $catalogUri.hashCode());
        String $warehouse = this.getWarehouse();
        result = result * 59 + ($warehouse == null ? 43 : $warehouse.hashCode());
        String $readStartCommit = this.getReadStartCommit();
        result = result * 59 + ($readStartCommit == null ? 43 : $readStartCommit.hashCode());
        List<HashMap<String, String>> $extList = this.getExtList();
        result = result * 59 + ($extList == null ? 43 : ((Object)$extList).hashCode());
        return result;
    }

    private static final class HudiSourceBuilderImpl
    extends HudiSourceBuilder<HudiSource, HudiSourceBuilderImpl> {
        private HudiSourceBuilderImpl() {
        }

        @Override
        protected HudiSourceBuilderImpl self() {
            return this;
        }

        @Override
        public HudiSource build() {
            return new HudiSource(this);
        }
    }

    public static abstract class HudiSourceBuilder<C extends HudiSource, B extends HudiSourceBuilder<C, B>>
    extends StreamSource.StreamSourceBuilder<C, B> {
        private String dbName;
        private String tableName;
        private String catalogUri;
        private String warehouse;
        private int checkIntervalInMinus;
        private boolean readStreamingSkipCompaction;
        private String readStartCommit;
        private List<HashMap<String, String>> extList;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B dbName(String dbName) {
            this.dbName = dbName;
            return (B)this.self();
        }

        public B tableName(String tableName) {
            this.tableName = tableName;
            return (B)this.self();
        }

        public B catalogUri(String catalogUri) {
            this.catalogUri = catalogUri;
            return (B)this.self();
        }

        public B warehouse(String warehouse) {
            this.warehouse = warehouse;
            return (B)this.self();
        }

        public B checkIntervalInMinus(int checkIntervalInMinus) {
            this.checkIntervalInMinus = checkIntervalInMinus;
            return (B)this.self();
        }

        public B readStreamingSkipCompaction(boolean readStreamingSkipCompaction) {
            this.readStreamingSkipCompaction = readStreamingSkipCompaction;
            return (B)this.self();
        }

        public B readStartCommit(String readStartCommit) {
            this.readStartCommit = readStartCommit;
            return (B)this.self();
        }

        public B extList(List<HashMap<String, String>> extList) {
            this.extList = extList;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "HudiSource.HudiSourceBuilder(super=" + super.toString() + ", dbName=" + this.dbName + ", tableName=" + this.tableName + ", catalogUri=" + this.catalogUri + ", warehouse=" + this.warehouse + ", checkIntervalInMinus=" + this.checkIntervalInMinus + ", readStreamingSkipCompaction=" + this.readStreamingSkipCompaction + ", readStartCommit=" + this.readStartCommit + ", extList=" + this.extList + ")";
        }
    }
}

