/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.source.file;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Map;
import org.apache.inlong.manager.common.enums.DataFormat;
import org.apache.inlong.manager.common.util.JsonTypeDefine;
import org.apache.inlong.manager.pojo.source.SourceRequest;

@JsonTypeDefine(value="FILE")
@ApiModel(value="File source request")
public class FileSourceRequest
extends SourceRequest {
    @ApiModelProperty(value="Path regex pattern for file, such as /a/b/*.txt", required=true)
    private String pattern;
    @ApiModelProperty(value="Path blacklist for file, which will be filtered and not collect", required=true)
    private String blackList;
    @ApiModelProperty(value="TimeOffset for collection, '1m' means from one minute after, '-1m' means from one minute before, '1h' means from one hour after, '-1h' means from one minute before, '1d' means from one day after, '-1d' means from one minute before, Null or blank means from current timestamp")
    private String timeOffset;
    @ApiModelProperty(value="Line end regex pattern, for example: &end&")
    private String lineEndPattern;
    @ApiModelProperty(value="Type of file content, for example: FULL, INCREMENT")
    private String contentCollectType;
    @ApiModelProperty(value="File needs to collect environment information, for example: kubernetes")
    private String envList;
    @ApiModelProperty(value="Metadata of data, for example: [{data:field1,field2},{kubernetes:namespace,labels,name,uuid}] and so on")
    private List<Map<String, String>> metaFields;
    @ApiModelProperty(value=" Type of data result for column separator         CSV format, set this parameter to a custom separator: , | :          Json format, set this parameter to json ")
    private String dataContentStyle;
    @ApiModelProperty(value="Cycle unit")
    private String cycleUnit;
    @ApiModelProperty(value="Max file count")
    private String maxFileCount;
    @ApiModelProperty(value="Time zone")
    private String timeZone;
    @ApiModelProperty(value="Whether retry")
    private Boolean retry;
    @ApiModelProperty(value="Data start time")
    private String dataTimeFrom;
    @ApiModelProperty(value="Data end time")
    private String dataTimeTo;
    @ApiModelProperty(value="filterStreams")
    private List<String> filterStreams;

    public FileSourceRequest() {
        this.setSourceType("FILE");
        this.setSerializationType(DataFormat.CSV.getName());
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getBlackList() {
        return this.blackList;
    }

    public String getTimeOffset() {
        return this.timeOffset;
    }

    public String getLineEndPattern() {
        return this.lineEndPattern;
    }

    public String getContentCollectType() {
        return this.contentCollectType;
    }

    public String getEnvList() {
        return this.envList;
    }

    public List<Map<String, String>> getMetaFields() {
        return this.metaFields;
    }

    public String getDataContentStyle() {
        return this.dataContentStyle;
    }

    public String getCycleUnit() {
        return this.cycleUnit;
    }

    public String getMaxFileCount() {
        return this.maxFileCount;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public Boolean getRetry() {
        return this.retry;
    }

    public String getDataTimeFrom() {
        return this.dataTimeFrom;
    }

    public String getDataTimeTo() {
        return this.dataTimeTo;
    }

    public List<String> getFilterStreams() {
        return this.filterStreams;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setBlackList(String blackList) {
        this.blackList = blackList;
    }

    public void setTimeOffset(String timeOffset) {
        this.timeOffset = timeOffset;
    }

    public void setLineEndPattern(String lineEndPattern) {
        this.lineEndPattern = lineEndPattern;
    }

    public void setContentCollectType(String contentCollectType) {
        this.contentCollectType = contentCollectType;
    }

    public void setEnvList(String envList) {
        this.envList = envList;
    }

    public void setMetaFields(List<Map<String, String>> metaFields) {
        this.metaFields = metaFields;
    }

    public void setDataContentStyle(String dataContentStyle) {
        this.dataContentStyle = dataContentStyle;
    }

    public void setCycleUnit(String cycleUnit) {
        this.cycleUnit = cycleUnit;
    }

    public void setMaxFileCount(String maxFileCount) {
        this.maxFileCount = maxFileCount;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public void setRetry(Boolean retry) {
        this.retry = retry;
    }

    public void setDataTimeFrom(String dataTimeFrom) {
        this.dataTimeFrom = dataTimeFrom;
    }

    public void setDataTimeTo(String dataTimeTo) {
        this.dataTimeTo = dataTimeTo;
    }

    public void setFilterStreams(List<String> filterStreams) {
        this.filterStreams = filterStreams;
    }

    @Override
    public String toString() {
        return "FileSourceRequest(super=" + super.toString() + ", pattern=" + this.getPattern() + ", blackList=" + this.getBlackList() + ", timeOffset=" + this.getTimeOffset() + ", lineEndPattern=" + this.getLineEndPattern() + ", contentCollectType=" + this.getContentCollectType() + ", envList=" + this.getEnvList() + ", metaFields=" + this.getMetaFields() + ", dataContentStyle=" + this.getDataContentStyle() + ", cycleUnit=" + this.getCycleUnit() + ", maxFileCount=" + this.getMaxFileCount() + ", timeZone=" + this.getTimeZone() + ", retry=" + this.getRetry() + ", dataTimeFrom=" + this.getDataTimeFrom() + ", dataTimeTo=" + this.getDataTimeTo() + ", filterStreams=" + this.getFilterStreams() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileSourceRequest)) {
            return false;
        }
        FileSourceRequest other = (FileSourceRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$retry = this.getRetry();
        Boolean other$retry = other.getRetry();
        if (this$retry == null ? other$retry != null : !((Object)this$retry).equals(other$retry)) {
            return false;
        }
        String this$pattern = this.getPattern();
        String other$pattern = other.getPattern();
        if (this$pattern == null ? other$pattern != null : !this$pattern.equals(other$pattern)) {
            return false;
        }
        String this$blackList = this.getBlackList();
        String other$blackList = other.getBlackList();
        if (this$blackList == null ? other$blackList != null : !this$blackList.equals(other$blackList)) {
            return false;
        }
        String this$timeOffset = this.getTimeOffset();
        String other$timeOffset = other.getTimeOffset();
        if (this$timeOffset == null ? other$timeOffset != null : !this$timeOffset.equals(other$timeOffset)) {
            return false;
        }
        String this$lineEndPattern = this.getLineEndPattern();
        String other$lineEndPattern = other.getLineEndPattern();
        if (this$lineEndPattern == null ? other$lineEndPattern != null : !this$lineEndPattern.equals(other$lineEndPattern)) {
            return false;
        }
        String this$contentCollectType = this.getContentCollectType();
        String other$contentCollectType = other.getContentCollectType();
        if (this$contentCollectType == null ? other$contentCollectType != null : !this$contentCollectType.equals(other$contentCollectType)) {
            return false;
        }
        String this$envList = this.getEnvList();
        String other$envList = other.getEnvList();
        if (this$envList == null ? other$envList != null : !this$envList.equals(other$envList)) {
            return false;
        }
        List<Map<String, String>> this$metaFields = this.getMetaFields();
        List<Map<String, String>> other$metaFields = other.getMetaFields();
        if (this$metaFields == null ? other$metaFields != null : !((Object)this$metaFields).equals(other$metaFields)) {
            return false;
        }
        String this$dataContentStyle = this.getDataContentStyle();
        String other$dataContentStyle = other.getDataContentStyle();
        if (this$dataContentStyle == null ? other$dataContentStyle != null : !this$dataContentStyle.equals(other$dataContentStyle)) {
            return false;
        }
        String this$cycleUnit = this.getCycleUnit();
        String other$cycleUnit = other.getCycleUnit();
        if (this$cycleUnit == null ? other$cycleUnit != null : !this$cycleUnit.equals(other$cycleUnit)) {
            return false;
        }
        String this$maxFileCount = this.getMaxFileCount();
        String other$maxFileCount = other.getMaxFileCount();
        if (this$maxFileCount == null ? other$maxFileCount != null : !this$maxFileCount.equals(other$maxFileCount)) {
            return false;
        }
        String this$timeZone = this.getTimeZone();
        String other$timeZone = other.getTimeZone();
        if (this$timeZone == null ? other$timeZone != null : !this$timeZone.equals(other$timeZone)) {
            return false;
        }
        String this$dataTimeFrom = this.getDataTimeFrom();
        String other$dataTimeFrom = other.getDataTimeFrom();
        if (this$dataTimeFrom == null ? other$dataTimeFrom != null : !this$dataTimeFrom.equals(other$dataTimeFrom)) {
            return false;
        }
        String this$dataTimeTo = this.getDataTimeTo();
        String other$dataTimeTo = other.getDataTimeTo();
        if (this$dataTimeTo == null ? other$dataTimeTo != null : !this$dataTimeTo.equals(other$dataTimeTo)) {
            return false;
        }
        List<String> this$filterStreams = this.getFilterStreams();
        List<String> other$filterStreams = other.getFilterStreams();
        return !(this$filterStreams == null ? other$filterStreams != null : !((Object)this$filterStreams).equals(other$filterStreams));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof FileSourceRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $retry = this.getRetry();
        result = result * 59 + ($retry == null ? 43 : ((Object)$retry).hashCode());
        String $pattern = this.getPattern();
        result = result * 59 + ($pattern == null ? 43 : $pattern.hashCode());
        String $blackList = this.getBlackList();
        result = result * 59 + ($blackList == null ? 43 : $blackList.hashCode());
        String $timeOffset = this.getTimeOffset();
        result = result * 59 + ($timeOffset == null ? 43 : $timeOffset.hashCode());
        String $lineEndPattern = this.getLineEndPattern();
        result = result * 59 + ($lineEndPattern == null ? 43 : $lineEndPattern.hashCode());
        String $contentCollectType = this.getContentCollectType();
        result = result * 59 + ($contentCollectType == null ? 43 : $contentCollectType.hashCode());
        String $envList = this.getEnvList();
        result = result * 59 + ($envList == null ? 43 : $envList.hashCode());
        List<Map<String, String>> $metaFields = this.getMetaFields();
        result = result * 59 + ($metaFields == null ? 43 : ((Object)$metaFields).hashCode());
        String $dataContentStyle = this.getDataContentStyle();
        result = result * 59 + ($dataContentStyle == null ? 43 : $dataContentStyle.hashCode());
        String $cycleUnit = this.getCycleUnit();
        result = result * 59 + ($cycleUnit == null ? 43 : $cycleUnit.hashCode());
        String $maxFileCount = this.getMaxFileCount();
        result = result * 59 + ($maxFileCount == null ? 43 : $maxFileCount.hashCode());
        String $timeZone = this.getTimeZone();
        result = result * 59 + ($timeZone == null ? 43 : $timeZone.hashCode());
        String $dataTimeFrom = this.getDataTimeFrom();
        result = result * 59 + ($dataTimeFrom == null ? 43 : $dataTimeFrom.hashCode());
        String $dataTimeTo = this.getDataTimeTo();
        result = result * 59 + ($dataTimeTo == null ? 43 : $dataTimeTo.hashCode());
        List<String> $filterStreams = this.getFilterStreams();
        result = result * 59 + ($filterStreams == null ? 43 : ((Object)$filterStreams).hashCode());
        return result;
    }
}

