/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sort.node.provider;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.inlong.common.enums.MetaField;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.FormatInfo;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.LongFormatInfo;
import org.apache.inlong.manager.pojo.sink.SinkField;
import org.apache.inlong.manager.pojo.sink.starrocks.StarRocksSink;
import org.apache.inlong.manager.pojo.sort.node.base.LoadNodeProvider;
import org.apache.inlong.manager.pojo.stream.StreamField;
import org.apache.inlong.manager.pojo.stream.StreamNode;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.node.LoadNode;
import org.apache.inlong.sort.protocol.node.format.Format;
import org.apache.inlong.sort.protocol.node.load.StarRocksLoadNode;
import org.apache.inlong.sort.protocol.transformation.FieldRelation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class StarRocksProvider
implements LoadNodeProvider {
    private static final Logger log = LoggerFactory.getLogger(StarRocksProvider.class);

    @Override
    public Boolean accept(String sinkType) {
        return "STARROCKS".equals(sinkType);
    }

    @Override
    public LoadNode createLoadNode(StreamNode nodeInfo, Map<String, StreamField> constantFieldMap) {
        StarRocksSink starRocksSink = (StarRocksSink)nodeInfo;
        Map<String, String> properties = this.parseProperties(starRocksSink.getProperties());
        List<FieldInfo> fieldInfos = this.parseSinkFieldInfos(starRocksSink.getSinkFieldList(), starRocksSink.getSinkName());
        List<FieldRelation> fieldRelations = this.parseSinkFields(starRocksSink.getSinkFieldList(), constantFieldMap);
        Format format = this.parsingSinkMultipleFormat(starRocksSink.getSinkMultipleEnable(), starRocksSink.getSinkMultipleFormat());
        return new StarRocksLoadNode(starRocksSink.getSinkName(), starRocksSink.getSinkName(), fieldInfos, fieldRelations, null, null, null, properties, starRocksSink.getJdbcUrl(), starRocksSink.getLoadUrl(), starRocksSink.getUsername(), starRocksSink.getPassword(), starRocksSink.getDatabaseName(), starRocksSink.getTableName(), starRocksSink.getPrimaryKey(), starRocksSink.getSinkMultipleEnable(), format, starRocksSink.getDatabasePattern(), starRocksSink.getTablePattern());
    }

    @Override
    public List<SinkField> addSinkMetaFields(List<SinkField> sinkFields) {
        List fieldNames = sinkFields.stream().map(SinkField::getFieldName).collect(Collectors.toList());
        if (!fieldNames.contains(MetaField.AUDIT_DATA_TIME.name())) {
            sinkFields.add(0, new SinkField(0, "long", MetaField.AUDIT_DATA_TIME.name(), "long", MetaField.AUDIT_DATA_TIME.name()));
        }
        return sinkFields;
    }

    @Override
    public List<FieldInfo> getMetaFields() {
        ArrayList<FieldInfo> fieldInfos = new ArrayList<FieldInfo>();
        fieldInfos.add(0, new FieldInfo(MetaField.AUDIT_DATA_TIME.name(), (FormatInfo)new LongFormatInfo()));
        return fieldInfos;
    }
}

