/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sort.node.provider;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.manager.pojo.sink.hive.HiveSink;
import org.apache.inlong.manager.pojo.sort.node.base.LoadNodeProvider;
import org.apache.inlong.manager.pojo.sort.util.FieldInfoUtils;
import org.apache.inlong.manager.pojo.stream.StreamField;
import org.apache.inlong.manager.pojo.stream.StreamNode;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.node.LoadNode;
import org.apache.inlong.sort.protocol.node.load.HiveLoadNode;
import org.apache.inlong.sort.protocol.transformation.FieldRelation;
import org.springframework.stereotype.Service;

@Service
public class HiveProvider
implements LoadNodeProvider {
    @Override
    public Boolean accept(String sinkType) {
        return "HIVE".equals(sinkType);
    }

    @Override
    public LoadNode createLoadNode(StreamNode nodeInfo, Map<String, StreamField> constantFieldMap) {
        HiveSink hiveSink = (HiveSink)nodeInfo;
        Map<String, String> properties = this.parseProperties(hiveSink.getProperties());
        List<FieldInfo> fieldInfos = this.parseSinkFieldInfos(hiveSink.getSinkFieldList(), hiveSink.getSinkName());
        List<FieldRelation> fieldRelations = this.parseSinkFields(hiveSink.getSinkFieldList(), constantFieldMap);
        List<Object> partitionFields = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(hiveSink.getPartitionFieldList())) {
            partitionFields = hiveSink.getPartitionFieldList().stream().map(partitionField -> new FieldInfo(partitionField.getFieldName(), hiveSink.getSinkName(), FieldInfoUtils.convertFieldFormat(partitionField.getFieldType(), partitionField.getFieldFormat()))).collect(Collectors.toList());
        }
        return new HiveLoadNode(hiveSink.getSinkName(), hiveSink.getSinkName(), fieldInfos, fieldRelations, (List)Lists.newArrayList(), null, null, properties, null, hiveSink.getDbName(), hiveSink.getTableName(), hiveSink.getHiveConfDir(), hiveSink.getHiveVersion(), null, (List)partitionFields);
    }
}

