/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sink.kafka;

import io.swagger.annotations.ApiModelProperty;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.pojo.sink.BaseStreamSink;
import org.apache.inlong.manager.pojo.sink.kafka.KafkaSinkRequest;

public class KafkaSinkDTO
extends BaseStreamSink {
    @ApiModelProperty(value="Kafka bootstrap servers")
    private String bootstrapServers;
    @ApiModelProperty(value="Kafka topicName")
    private String topicName;
    @ApiModelProperty(value="Partition number of the topic")
    private Integer partitionNum;
    @ApiModelProperty(value="Data Serialization, support: json, canal, avro")
    private String serializationType;
    @ApiModelProperty(value="The strategy of auto offset reset", notes="including earliest, latest (the default), none")
    private String autoOffsetReset;
    @ApiModelProperty(value="Primary key is required when serializationType is json, avro")
    private String primaryKey;
    @ApiModelProperty(value="Properties for kafka")
    private Map<String, Object> properties;

    public static KafkaSinkDTO getFromRequest(KafkaSinkRequest request, String extParams) {
        KafkaSinkDTO dto = StringUtils.isNotBlank((CharSequence)extParams) ? KafkaSinkDTO.getFromJson(extParams) : new KafkaSinkDTO();
        return (KafkaSinkDTO)CommonBeanUtils.copyProperties((Object)request, (Object)dto, (boolean)true);
    }

    public static KafkaSinkDTO getFromJson(@NotNull String extParams) {
        try {
            return (KafkaSinkDTO)JsonUtils.parseObject((String)extParams, KafkaSinkDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SINK_INFO_INCORRECT, String.format("parse extParams of Kafka SinkDTO failure: %s", e.getMessage()));
        }
    }

    public static KafkaSinkDTOBuilder builder() {
        return new KafkaSinkDTOBuilder();
    }

    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public Integer getPartitionNum() {
        return this.partitionNum;
    }

    public String getSerializationType() {
        return this.serializationType;
    }

    public String getAutoOffsetReset() {
        return this.autoOffsetReset;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setBootstrapServers(String bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    public void setPartitionNum(Integer partitionNum) {
        this.partitionNum = partitionNum;
    }

    public void setSerializationType(String serializationType) {
        this.serializationType = serializationType;
    }

    public void setAutoOffsetReset(String autoOffsetReset) {
        this.autoOffsetReset = autoOffsetReset;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaSinkDTO)) {
            return false;
        }
        KafkaSinkDTO other = (KafkaSinkDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$partitionNum = this.getPartitionNum();
        Integer other$partitionNum = other.getPartitionNum();
        if (this$partitionNum == null ? other$partitionNum != null : !((Object)this$partitionNum).equals(other$partitionNum)) {
            return false;
        }
        String this$bootstrapServers = this.getBootstrapServers();
        String other$bootstrapServers = other.getBootstrapServers();
        if (this$bootstrapServers == null ? other$bootstrapServers != null : !this$bootstrapServers.equals(other$bootstrapServers)) {
            return false;
        }
        String this$topicName = this.getTopicName();
        String other$topicName = other.getTopicName();
        if (this$topicName == null ? other$topicName != null : !this$topicName.equals(other$topicName)) {
            return false;
        }
        String this$serializationType = this.getSerializationType();
        String other$serializationType = other.getSerializationType();
        if (this$serializationType == null ? other$serializationType != null : !this$serializationType.equals(other$serializationType)) {
            return false;
        }
        String this$autoOffsetReset = this.getAutoOffsetReset();
        String other$autoOffsetReset = other.getAutoOffsetReset();
        if (this$autoOffsetReset == null ? other$autoOffsetReset != null : !this$autoOffsetReset.equals(other$autoOffsetReset)) {
            return false;
        }
        String this$primaryKey = this.getPrimaryKey();
        String other$primaryKey = other.getPrimaryKey();
        if (this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey)) {
            return false;
        }
        Map<String, Object> this$properties = this.getProperties();
        Map<String, Object> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof KafkaSinkDTO;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $partitionNum = this.getPartitionNum();
        result = result * 59 + ($partitionNum == null ? 43 : ((Object)$partitionNum).hashCode());
        String $bootstrapServers = this.getBootstrapServers();
        result = result * 59 + ($bootstrapServers == null ? 43 : $bootstrapServers.hashCode());
        String $topicName = this.getTopicName();
        result = result * 59 + ($topicName == null ? 43 : $topicName.hashCode());
        String $serializationType = this.getSerializationType();
        result = result * 59 + ($serializationType == null ? 43 : $serializationType.hashCode());
        String $autoOffsetReset = this.getAutoOffsetReset();
        result = result * 59 + ($autoOffsetReset == null ? 43 : $autoOffsetReset.hashCode());
        String $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        Map<String, Object> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "KafkaSinkDTO(bootstrapServers=" + this.getBootstrapServers() + ", topicName=" + this.getTopicName() + ", partitionNum=" + this.getPartitionNum() + ", serializationType=" + this.getSerializationType() + ", autoOffsetReset=" + this.getAutoOffsetReset() + ", primaryKey=" + this.getPrimaryKey() + ", properties=" + this.getProperties() + ")";
    }

    public KafkaSinkDTO() {
    }

    public KafkaSinkDTO(String bootstrapServers, String topicName, Integer partitionNum, String serializationType, String autoOffsetReset, String primaryKey, Map<String, Object> properties) {
        this.bootstrapServers = bootstrapServers;
        this.topicName = topicName;
        this.partitionNum = partitionNum;
        this.serializationType = serializationType;
        this.autoOffsetReset = autoOffsetReset;
        this.primaryKey = primaryKey;
        this.properties = properties;
    }

    public static class KafkaSinkDTOBuilder {
        private String bootstrapServers;
        private String topicName;
        private Integer partitionNum;
        private String serializationType;
        private String autoOffsetReset;
        private String primaryKey;
        private Map<String, Object> properties;

        KafkaSinkDTOBuilder() {
        }

        public KafkaSinkDTOBuilder bootstrapServers(String bootstrapServers) {
            this.bootstrapServers = bootstrapServers;
            return this;
        }

        public KafkaSinkDTOBuilder topicName(String topicName) {
            this.topicName = topicName;
            return this;
        }

        public KafkaSinkDTOBuilder partitionNum(Integer partitionNum) {
            this.partitionNum = partitionNum;
            return this;
        }

        public KafkaSinkDTOBuilder serializationType(String serializationType) {
            this.serializationType = serializationType;
            return this;
        }

        public KafkaSinkDTOBuilder autoOffsetReset(String autoOffsetReset) {
            this.autoOffsetReset = autoOffsetReset;
            return this;
        }

        public KafkaSinkDTOBuilder primaryKey(String primaryKey) {
            this.primaryKey = primaryKey;
            return this;
        }

        public KafkaSinkDTOBuilder properties(Map<String, Object> properties) {
            this.properties = properties;
            return this;
        }

        public KafkaSinkDTO build() {
            return new KafkaSinkDTO(this.bootstrapServers, this.topicName, this.partitionNum, this.serializationType, this.autoOffsetReset, this.primaryKey, this.properties);
        }

        public String toString() {
            return "KafkaSinkDTO.KafkaSinkDTOBuilder(bootstrapServers=" + this.bootstrapServers + ", topicName=" + this.topicName + ", partitionNum=" + this.partitionNum + ", serializationType=" + this.serializationType + ", autoOffsetReset=" + this.autoOffsetReset + ", primaryKey=" + this.primaryKey + ", properties=" + this.properties + ")";
        }
    }
}

