/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sink.iceberg;

public enum IcebergType {
    BOOLEAN("boolean"),
    INT("int"),
    LONG("long"),
    FLOAT("float"),
    DOUBLE("double"),
    DECIMAL("decimal"),
    DATE("date"),
    TIME("time"),
    TIMESTAMP("timestamp"),
    TIMESTAMPTZ("timestamptz"),
    STRING("string"),
    UUID("uuid"),
    FIXED("fixed"),
    BINARY("binary");

    private final String type;

    private IcebergType(String type) {
        this.type = type;
    }

    public static IcebergType forType(String type) {
        for (IcebergType ibType : IcebergType.values()) {
            if (!ibType.getType().equalsIgnoreCase(type)) continue;
            return ibType;
        }
        throw new IllegalArgumentException(String.format("invalid iceberg type = %s", type));
    }

    public String getType() {
        return this.type;
    }
}

