/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sink.iceberg;

import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonTypeDefine;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.pojo.sink.SinkField;

@JsonTypeDefine(value="ICEBERG")
public class IcebergColumnInfo
extends SinkField {
    @ApiModelProperty(value="Length of fixed type")
    private Integer length;
    @ApiModelProperty(value="Precision of decimal type")
    private Integer precision;
    @ApiModelProperty(value="Scale of decimal type")
    private Integer scale;
    @ApiModelProperty(value="Field partition strategy, including: None, Identity, Year, Month, Day, Hour, Bucket, Truncate")
    private String partitionStrategy;
    @ApiModelProperty(value="Bucket num param of bucket partition")
    private Integer bucketNum;
    @ApiModelProperty(value="Width param of truncate partition")
    private Integer width;
    private boolean required;

    public static IcebergColumnInfo getFromRequest(SinkField sinkField) {
        return (IcebergColumnInfo)CommonBeanUtils.copyProperties((Object)sinkField, IcebergColumnInfo::new, (boolean)true);
    }

    public static IcebergColumnInfo getFromJson(String extParams) {
        if (StringUtils.isEmpty((CharSequence)extParams)) {
            return new IcebergColumnInfo();
        }
        try {
            return (IcebergColumnInfo)JsonUtils.parseObject((String)extParams, IcebergColumnInfo.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SINK_INFO_INCORRECT.getMessage() + ": " + e.getMessage());
        }
    }

    public Integer getLength() {
        return this.length;
    }

    public Integer getPrecision() {
        return this.precision;
    }

    public Integer getScale() {
        return this.scale;
    }

    public String getPartitionStrategy() {
        return this.partitionStrategy;
    }

    public Integer getBucketNum() {
        return this.bucketNum;
    }

    public Integer getWidth() {
        return this.width;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setLength(Integer length) {
        this.length = length;
    }

    public void setPrecision(Integer precision) {
        this.precision = precision;
    }

    public void setScale(Integer scale) {
        this.scale = scale;
    }

    public void setPartitionStrategy(String partitionStrategy) {
        this.partitionStrategy = partitionStrategy;
    }

    public void setBucketNum(Integer bucketNum) {
        this.bucketNum = bucketNum;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IcebergColumnInfo)) {
            return false;
        }
        IcebergColumnInfo other = (IcebergColumnInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isRequired() != other.isRequired()) {
            return false;
        }
        Integer this$length = this.getLength();
        Integer other$length = other.getLength();
        if (this$length == null ? other$length != null : !((Object)this$length).equals(other$length)) {
            return false;
        }
        Integer this$precision = this.getPrecision();
        Integer other$precision = other.getPrecision();
        if (this$precision == null ? other$precision != null : !((Object)this$precision).equals(other$precision)) {
            return false;
        }
        Integer this$scale = this.getScale();
        Integer other$scale = other.getScale();
        if (this$scale == null ? other$scale != null : !((Object)this$scale).equals(other$scale)) {
            return false;
        }
        Integer this$bucketNum = this.getBucketNum();
        Integer other$bucketNum = other.getBucketNum();
        if (this$bucketNum == null ? other$bucketNum != null : !((Object)this$bucketNum).equals(other$bucketNum)) {
            return false;
        }
        Integer this$width = this.getWidth();
        Integer other$width = other.getWidth();
        if (this$width == null ? other$width != null : !((Object)this$width).equals(other$width)) {
            return false;
        }
        String this$partitionStrategy = this.getPartitionStrategy();
        String other$partitionStrategy = other.getPartitionStrategy();
        return !(this$partitionStrategy == null ? other$partitionStrategy != null : !this$partitionStrategy.equals(other$partitionStrategy));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof IcebergColumnInfo;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isRequired() ? 79 : 97);
        Integer $length = this.getLength();
        result = result * 59 + ($length == null ? 43 : ((Object)$length).hashCode());
        Integer $precision = this.getPrecision();
        result = result * 59 + ($precision == null ? 43 : ((Object)$precision).hashCode());
        Integer $scale = this.getScale();
        result = result * 59 + ($scale == null ? 43 : ((Object)$scale).hashCode());
        Integer $bucketNum = this.getBucketNum();
        result = result * 59 + ($bucketNum == null ? 43 : ((Object)$bucketNum).hashCode());
        Integer $width = this.getWidth();
        result = result * 59 + ($width == null ? 43 : ((Object)$width).hashCode());
        String $partitionStrategy = this.getPartitionStrategy();
        result = result * 59 + ($partitionStrategy == null ? 43 : $partitionStrategy.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "IcebergColumnInfo(length=" + this.getLength() + ", precision=" + this.getPrecision() + ", scale=" + this.getScale() + ", partitionStrategy=" + this.getPartitionStrategy() + ", bucketNum=" + this.getBucketNum() + ", width=" + this.getWidth() + ", required=" + this.isRequired() + ")";
    }

    public IcebergColumnInfo() {
    }

    public IcebergColumnInfo(Integer length, Integer precision, Integer scale, String partitionStrategy, Integer bucketNum, Integer width, boolean required) {
        this.length = length;
        this.precision = precision;
        this.scale = scale;
        this.partitionStrategy = partitionStrategy;
        this.bucketNum = bucketNum;
        this.width = width;
        this.required = required;
    }
}

