/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.cluster.pulsar;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.Pattern;
import org.apache.inlong.manager.common.util.JsonTypeDefine;
import org.apache.inlong.manager.pojo.cluster.ClusterRequest;

@JsonTypeDefine(value="PULSAR")
@ApiModel(value="Inlong cluster request for Pulsar")
public class PulsarClusterRequest
extends ClusterRequest {
    @ApiModelProperty(value="Pulsar admin URL, such as: http://127.0.0.1:8080", notes="Pulsar service URL is the 'url' field of the cluster")
    @Pattern(regexp="^((?!\\s).)*$", message="not supports blank in url")
    private @Pattern(regexp="^((?!\\s).)*$", message="not supports blank in url") String adminUrl;
    @ApiModelProperty(value="Pulsar tenant, default is 'public'")
    private String pulsarTenant = "public";

    public PulsarClusterRequest() {
        this.setType("PULSAR");
    }

    public String getAdminUrl() {
        return this.adminUrl;
    }

    public String getPulsarTenant() {
        return this.pulsarTenant;
    }

    public void setAdminUrl(String adminUrl) {
        this.adminUrl = adminUrl;
    }

    public void setPulsarTenant(String pulsarTenant) {
        this.pulsarTenant = pulsarTenant;
    }

    @Override
    public String toString() {
        return "PulsarClusterRequest(super=" + super.toString() + ", adminUrl=" + this.getAdminUrl() + ", pulsarTenant=" + this.getPulsarTenant() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PulsarClusterRequest)) {
            return false;
        }
        PulsarClusterRequest other = (PulsarClusterRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$adminUrl = this.getAdminUrl();
        String other$adminUrl = other.getAdminUrl();
        if (this$adminUrl == null ? other$adminUrl != null : !this$adminUrl.equals(other$adminUrl)) {
            return false;
        }
        String this$pulsarTenant = this.getPulsarTenant();
        String other$pulsarTenant = other.getPulsarTenant();
        return !(this$pulsarTenant == null ? other$pulsarTenant != null : !this$pulsarTenant.equals(other$pulsarTenant));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PulsarClusterRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $adminUrl = this.getAdminUrl();
        result = result * 59 + ($adminUrl == null ? 43 : $adminUrl.hashCode());
        String $pulsarTenant = this.getPulsarTenant();
        result = result * 59 + ($pulsarTenant == null ? 43 : $pulsarTenant.hashCode());
        return result;
    }
}

