/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.cluster.dataproxy;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.pojo.cluster.dataproxy.DataProxyClusterNodeRequest;

@ApiModel(value="DataProxy cluster node info")
public class DataProxyClusterNodeDTO {
    @ApiModelProperty(value="Report source type")
    private String reportSourceType = "INLONG";
    @ApiModelProperty(value="Enabled")
    private Boolean enabledOnline = true;

    public static DataProxyClusterNodeDTO getFromRequest(DataProxyClusterNodeRequest request, String extParams) {
        DataProxyClusterNodeDTO dto = StringUtils.isNotBlank((CharSequence)extParams) ? DataProxyClusterNodeDTO.getFromJson(extParams) : new DataProxyClusterNodeDTO();
        return (DataProxyClusterNodeDTO)CommonBeanUtils.copyProperties((Object)request, (Object)dto, (boolean)true);
    }

    public static DataProxyClusterNodeDTO getFromJson(@NotNull String extParams) {
        try {
            return (DataProxyClusterNodeDTO)JsonUtils.parseObject((String)extParams, DataProxyClusterNodeDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.CLUSTER_INFO_INCORRECT.getMessage() + ": " + e.getMessage());
        }
    }

    public static DataProxyClusterNodeDTOBuilder builder() {
        return new DataProxyClusterNodeDTOBuilder();
    }

    public String getReportSourceType() {
        return this.reportSourceType;
    }

    public Boolean getEnabledOnline() {
        return this.enabledOnline;
    }

    public void setReportSourceType(String reportSourceType) {
        this.reportSourceType = reportSourceType;
    }

    public void setEnabledOnline(Boolean enabledOnline) {
        this.enabledOnline = enabledOnline;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataProxyClusterNodeDTO)) {
            return false;
        }
        DataProxyClusterNodeDTO other = (DataProxyClusterNodeDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$enabledOnline = this.getEnabledOnline();
        Boolean other$enabledOnline = other.getEnabledOnline();
        if (this$enabledOnline == null ? other$enabledOnline != null : !((Object)this$enabledOnline).equals(other$enabledOnline)) {
            return false;
        }
        String this$reportSourceType = this.getReportSourceType();
        String other$reportSourceType = other.getReportSourceType();
        return !(this$reportSourceType == null ? other$reportSourceType != null : !this$reportSourceType.equals(other$reportSourceType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataProxyClusterNodeDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $enabledOnline = this.getEnabledOnline();
        result = result * 59 + ($enabledOnline == null ? 43 : ((Object)$enabledOnline).hashCode());
        String $reportSourceType = this.getReportSourceType();
        result = result * 59 + ($reportSourceType == null ? 43 : $reportSourceType.hashCode());
        return result;
    }

    public String toString() {
        return "DataProxyClusterNodeDTO(reportSourceType=" + this.getReportSourceType() + ", enabledOnline=" + this.getEnabledOnline() + ")";
    }

    public DataProxyClusterNodeDTO() {
    }

    public DataProxyClusterNodeDTO(String reportSourceType, Boolean enabledOnline) {
        this.reportSourceType = reportSourceType;
        this.enabledOnline = enabledOnline;
    }

    public static class DataProxyClusterNodeDTOBuilder {
        private String reportSourceType;
        private Boolean enabledOnline;

        DataProxyClusterNodeDTOBuilder() {
        }

        public DataProxyClusterNodeDTOBuilder reportSourceType(String reportSourceType) {
            this.reportSourceType = reportSourceType;
            return this;
        }

        public DataProxyClusterNodeDTOBuilder enabledOnline(Boolean enabledOnline) {
            this.enabledOnline = enabledOnline;
            return this;
        }

        public DataProxyClusterNodeDTO build() {
            return new DataProxyClusterNodeDTO(this.reportSourceType, this.enabledOnline);
        }

        public String toString() {
            return "DataProxyClusterNodeDTO.DataProxyClusterNodeDTOBuilder(reportSourceType=" + this.reportSourceType + ", enabledOnline=" + this.enabledOnline + ")";
        }
    }
}

