/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.util.ArrayList;
import java.util.List;
import org.apache.kudu.client.KuduRpcResponse;
import org.apache.kudu.client.Operation;
import org.apache.kudu.client.RowError;
import org.apache.kudu.tserver.Tserver;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class OperationResponse
extends KuduRpcResponse {
    private final long writeTimestamp;
    private final RowError rowError;
    private final Operation operation;

    OperationResponse(long elapsedMillis, String tsUUID, long writeTimestamp, Operation operation, Tserver.WriteResponsePB.PerRowErrorPB errorPB) {
        super(elapsedMillis, tsUUID);
        this.writeTimestamp = writeTimestamp;
        this.rowError = errorPB == null ? null : RowError.fromRowErrorPb(errorPB, operation, tsUUID);
        this.operation = operation;
    }

    OperationResponse(long elapsedMillis, String tsUUID, long writeTimestamp, Operation operation, RowError rowError) {
        super(elapsedMillis, tsUUID);
        this.writeTimestamp = writeTimestamp;
        this.rowError = rowError;
        this.operation = operation;
    }

    public static List<RowError> collectErrors(List<OperationResponse> responses) {
        ArrayList<RowError> errors = new ArrayList<RowError>(responses.size());
        for (OperationResponse resp : responses) {
            if (!resp.hasRowError()) continue;
            errors.add(resp.getRowError());
        }
        return errors;
    }

    @InterfaceAudience.Private
    public long getWriteTimestampRaw() {
        return this.writeTimestamp;
    }

    public RowError getRowError() {
        return this.rowError;
    }

    public boolean hasRowError() {
        return this.rowError != null;
    }

    Operation getOperation() {
        return this.operation;
    }
}

