/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.cmd.parser;

import com.moilioncircle.redis.replicator.cmd.CommandParser;
import com.moilioncircle.redis.replicator.cmd.CommandParsers;
import com.moilioncircle.redis.replicator.cmd.impl.Limit;
import com.moilioncircle.redis.replicator.cmd.impl.OrderType;
import com.moilioncircle.redis.replicator.cmd.impl.SortCommand;
import com.moilioncircle.redis.replicator.util.Strings;
import java.util.ArrayList;

public class SortParser
implements CommandParser<SortCommand> {
    @Override
    public SortCommand parse(Object[] command) {
        int idx = 1;
        SortCommand sort = new SortCommand();
        byte[] key = CommandParsers.toBytes(command[idx]);
        ++idx;
        sort.setKey(key);
        sort.setOrder(OrderType.NONE);
        ArrayList<byte[]> getPatterns = new ArrayList<byte[]>();
        while (idx < command.length) {
            String param = CommandParsers.toRune(command[idx]);
            if (Strings.isEquals(param, "ASC")) {
                sort.setOrder(OrderType.ASC);
            } else if (Strings.isEquals(param, "DESC")) {
                sort.setOrder(OrderType.DESC);
            } else if (Strings.isEquals(param, "ALPHA")) {
                sort.setAlpha(true);
            } else if (Strings.isEquals(param, "LIMIT") && idx + 2 < command.length) {
                long offset = CommandParsers.toLong(command[++idx]);
                long count = CommandParsers.toLong(command[++idx]);
                sort.setLimit(new Limit(offset, count));
            } else if (Strings.isEquals(param, "STORE") && idx + 1 < command.length) {
                byte[] destination = CommandParsers.toBytes(command[++idx]);
                sort.setDestination(destination);
            } else if (Strings.isEquals(param, "BY") && idx + 1 < command.length) {
                byte[] byPattern = CommandParsers.toBytes(command[++idx]);
                sort.setByPattern(byPattern);
            } else if (Strings.isEquals(param, "GET") && idx + 1 < command.length) {
                byte[] getPattern = CommandParsers.toBytes(command[++idx]);
                getPatterns.add(getPattern);
            }
            ++idx;
        }
        sort.setGetPatterns((byte[][])getPatterns.toArray((T[])new byte[getPatterns.size()][]));
        return sort;
    }
}

