/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.cmd.parser;

import com.moilioncircle.redis.replicator.cmd.CommandParser;
import com.moilioncircle.redis.replicator.cmd.CommandParsers;
import com.moilioncircle.redis.replicator.cmd.impl.ExistType;
import com.moilioncircle.redis.replicator.cmd.impl.SetCommand;
import com.moilioncircle.redis.replicator.cmd.impl.XATType;
import com.moilioncircle.redis.replicator.rdb.datatype.ExpiredType;
import com.moilioncircle.redis.replicator.util.Strings;

public class SetParser
implements CommandParser<SetCommand> {
    @Override
    public SetCommand parse(Object[] command) {
        byte[] key = CommandParsers.toBytes(command[1]);
        byte[] value = CommandParsers.toBytes(command[2]);
        int idx = 3;
        ExistType existType = ExistType.NONE;
        Long expiredValue = null;
        XATType xatType = XATType.NONE;
        Long xatValue = null;
        boolean et = false;
        boolean st = false;
        boolean keepTtl = false;
        boolean get = false;
        ExpiredType expiredType = ExpiredType.NONE;
        while (idx < command.length) {
            String param = CommandParsers.toRune(command[idx++]);
            if (!et && Strings.isEquals(param, "NX")) {
                existType = ExistType.NX;
                et = true;
            } else if (!et && Strings.isEquals(param, "XX")) {
                existType = ExistType.XX;
                et = true;
            } else if (!keepTtl && Strings.isEquals(param, "KEEPTTL")) {
                keepTtl = true;
            } else if (!keepTtl && Strings.isEquals(param, "GET")) {
                get = true;
            }
            if (!st && Strings.isEquals(param, "EX")) {
                expiredType = ExpiredType.SECOND;
                expiredValue = Long.valueOf(CommandParsers.toRune(command[idx++]));
                st = true;
                continue;
            }
            if (!st && Strings.isEquals(param, "PX")) {
                expiredType = ExpiredType.MS;
                expiredValue = Long.valueOf(CommandParsers.toRune(command[idx++]));
                st = true;
                continue;
            }
            if (!st && Strings.isEquals(param, "EXAT")) {
                xatType = XATType.EXAT;
                xatValue = Long.valueOf(CommandParsers.toRune(command[idx++]));
                st = true;
                continue;
            }
            if (st || !Strings.isEquals(param, "PXAT")) continue;
            xatType = XATType.PXAT;
            xatValue = Long.valueOf(CommandParsers.toRune(command[idx++]));
            st = true;
        }
        return new SetCommand(key, value, keepTtl, expiredType, expiredValue, xatType, xatValue, existType, get);
    }
}

