/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator;

import com.moilioncircle.redis.replicator.Configuration;
import com.moilioncircle.redis.replicator.Replicator;
import com.moilioncircle.redis.replicator.ReplicatorRetrier;
import java.io.IOException;
import java.io.UncheckedIOException;

abstract class AbstractReplicatorRetrier
implements ReplicatorRetrier {
    protected int retries = 0;

    AbstractReplicatorRetrier() {
    }

    protected abstract boolean isManualClosed();

    protected abstract boolean open() throws IOException;

    protected abstract boolean connect() throws IOException;

    protected abstract boolean close(IOException var1) throws IOException;

    @Override
    public void retry(Replicator replicator) throws IOException {
        IOException exception = null;
        Configuration configuration = replicator.getConfiguration();
        while (this.retries < configuration.getRetries() || configuration.getRetries() <= 0) {
            block6: {
                exception = null;
                if (this.isManualClosed()) break;
                long interval = configuration.getRetryTimeInterval();
                try {
                    if (this.connect()) {
                        this.reset();
                    }
                    if (!this.open()) {
                        this.reset();
                        this.close(null);
                        this.sleep(interval);
                        break block6;
                    }
                    exception = null;
                    break;
                }
                catch (IOException | UncheckedIOException e) {
                    exception = this.translate(e);
                    this.close(exception);
                    this.sleep(interval);
                }
            }
            ++this.retries;
        }
        if (exception != null) {
            throw exception;
        }
    }

    protected void reset() {
        this.retries = 0;
    }

    protected void sleep(long interval) {
        try {
            Thread.sleep(interval);
        }
        catch (InterruptedException interrupt) {
            Thread.currentThread().interrupt();
        }
    }

    protected IOException translate(Exception e) {
        if (e instanceof UncheckedIOException) {
            return ((UncheckedIOException)e).getCause();
        }
        if (e instanceof IOException) {
            return (IOException)e;
        }
        return new IOException(e.getMessage());
    }
}

