/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.util;

import java.util.Collections;
import java.util.Map;
import org.slf4j.MDC;

public class LoggingContext {
    public static final String CONNECTOR_TYPE = "dbz.connectorType";
    public static final String CONNECTOR_NAME = "dbz.connectorName";
    public static final String CONNECTOR_CONTEXT = "dbz.connectorContext";

    private LoggingContext() {
    }

    public static PreviousContext forConnector(String connectorType, String connectorName, String contextName) {
        if (connectorType == null) {
            throw new IllegalArgumentException("The MDC value for the connector type may not be null");
        }
        if (connectorName == null) {
            throw new IllegalArgumentException("The MDC value for the connector name may not be null");
        }
        if (contextName == null) {
            throw new IllegalArgumentException("The MDC value for the connector context may not be null");
        }
        PreviousContext previous = new PreviousContext();
        MDC.put((String)CONNECTOR_TYPE, (String)connectorType);
        MDC.put((String)CONNECTOR_NAME, (String)connectorName);
        MDC.put((String)CONNECTOR_CONTEXT, (String)contextName);
        return previous;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void temporarilyForConnector(String connectorType, String connectorName, String contextName, Runnable operation) {
        if (connectorType == null) {
            throw new IllegalArgumentException("The MDC value for the connector type may not be null");
        }
        if (connectorName == null) {
            throw new IllegalArgumentException("The MDC value for the connector name may not be null");
        }
        if (contextName == null) {
            throw new IllegalArgumentException("The MDC value for the connector context may not be null");
        }
        if (operation == null) {
            throw new IllegalArgumentException("The operation may not be null");
        }
        PreviousContext previous = new PreviousContext();
        try {
            LoggingContext.forConnector(connectorType, connectorName, contextName);
            operation.run();
        }
        finally {
            previous.restore();
        }
    }

    public static final class PreviousContext {
        private static final Map<String, String> EMPTY_CONTEXT = Collections.emptyMap();
        private final Map<String, String> context;

        protected PreviousContext() {
            Map<String, String> context = MDC.getCopyOfContextMap();
            this.context = context != null ? context : EMPTY_CONTEXT;
        }

        public void restore() {
            MDC.setContextMap(this.context);
        }
    }
}

