/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import kafka.log.AbortedTxn;
import kafka.log.BatchMetadata;
import kafka.log.CorruptSnapshotException;
import kafka.log.Log$;
import kafka.log.OffsetIndex;
import kafka.log.OffsetIndex$;
import kafka.log.OffsetPosition;
import kafka.log.ProducerStateEntry;
import kafka.log.ProducerStateManager$;
import kafka.log.TimeIndex;
import kafka.log.TimeIndex$;
import kafka.log.TimestampOffset;
import kafka.log.TransactionIndex;
import kafka.tools.DumpLogSegments;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Implicits$;
import kafka.utils.Implicits$MapExtensionMethods$;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.FileLogInputStream;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.compat.MapExtensionMethods$;
import scala.collection.compat.package$;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;

public final class DumpLogSegments$ {
    public static DumpLogSegments$ MODULE$;
    private final String RecordIndent;

    static {
        new DumpLogSegments$();
    }

    public String RecordIndent() {
        return this.RecordIndent;
    }

    /*
     * WARNING - void declaration
     */
    public void main(String[] args) {
        void forKeyValue$extension_foreachEntry$extension_f;
        void forKeyValue$extension_foreachEntry$extension_$this;
        void forKeyValue$extension_$this;
        void forKeyValue$extension_f;
        void forKeyValue$extension_foreachEntry$extension_f2;
        void forKeyValue$extension_foreachEntry$extension_$this2;
        void forKeyValue$extension_$this2;
        void forKeyValue$extension_f2;
        DumpLogSegments.DumpLogSegmentsOptions opts = new DumpLogSegments.DumpLogSegmentsOptions(args);
        CommandLineUtils$.MODULE$.printHelpAndExitIfNeeded(opts, "This tool helps to parse a log file and dump its contents to the console, useful for debugging a seemingly corrupt log segment.");
        opts.checkArgs();
        scala.collection.mutable.Map misMatchesForIndexFilesMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        DumpLogSegments.TimeIndexDumpErrors timeIndexDumpErrors = new DumpLogSegments.TimeIndexDumpErrors();
        scala.collection.mutable.Map nonConsecutivePairsForLogFilesMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        ArrayOps.ofRef foreach_this = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])opts.files()));
        int foreach_len = foreach_this.length();
        for (int foreach_i = 0; foreach_i < foreach_len; ++foreach_i) {
            String string = (String)foreach_this.apply(foreach_i);
            DumpLogSegments$.$anonfun$main$1(opts, nonConsecutivePairsForLogFilesMap, misMatchesForIndexFilesMap, timeIndexDumpErrors, string);
        }
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(fileName, listOfMismatches) -> {
            DumpLogSegments$.$anonfun$main$2(fileName, listOfMismatches);
            return BoxedUnit.UNIT;
        };
        Map map = Implicits$.MODULE$.MapExtensionMethods(misMatchesForIndexFilesMap);
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        Function2 & Serializable & scala.Serializable intersect2 = (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f2, arg_0, arg_1);
        Map map2 = package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this2);
        if (MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        forKeyValue$extension_foreachEntry$extension_$this2.foreach(arg_0 -> MapExtensionMethods$.$anonfun$foreachEntry$1((Function2)forKeyValue$extension_foreachEntry$extension_f2, arg_0));
        timeIndexDumpErrors.printErrors();
        Function2 & Serializable & scala.Serializable intersect3 = (Function2 & Serializable & scala.Serializable)(fileName, listOfNonConsecutivePairs) -> {
            DumpLogSegments$.$anonfun$main$4(fileName, listOfNonConsecutivePairs);
            return BoxedUnit.UNIT;
        };
        Map map3 = Implicits$.MODULE$.MapExtensionMethods(nonConsecutivePairsForLogFilesMap);
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        Function2 & Serializable & scala.Serializable intersect4 = (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1);
        Map map4 = package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this);
        if (MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        forKeyValue$extension_foreachEntry$extension_$this.foreach(arg_0 -> MapExtensionMethods$.$anonfun$foreachEntry$1((Function2)forKeyValue$extension_foreachEntry$extension_f, arg_0));
    }

    private void dumpTxnIndex(File file) {
        List list = new TransactionIndex(Log$.MODULE$.offsetFromFile(file), file).allAbortedTxns();
        if (list == null) {
            throw null;
        }
        List foreach_these = list;
        while (!foreach_these.isEmpty()) {
            Predef$.MODULE$.println((Object)new StringBuilder(68).append("version: ").append(((AbortedTxn)foreach_these.head()).version()).append(" producerId: ").append(((AbortedTxn)foreach_these.head()).producerId()).append(" firstOffset: ").append(((AbortedTxn)foreach_these.head()).firstOffset()).append(" ").append("lastOffset: ").append(((AbortedTxn)foreach_these.head()).lastOffset()).append(" lastStableOffset: ").append(((AbortedTxn)foreach_these.head()).lastStableOffset()).toString());
            foreach_these = (List)foreach_these.tail();
        }
    }

    private void dumpProducerIdSnapshot(File file) {
        try {
            ProducerStateManager$.MODULE$.readSnapshot(file).foreach((Function1 & Serializable & scala.Serializable)entry -> {
                DumpLogSegments$.$anonfun$dumpProducerIdSnapshot$1(entry);
                return BoxedUnit.UNIT;
            });
            return;
        }
        catch (CorruptSnapshotException e) {
            System.err.println(e.getMessage());
            return;
        }
    }

    public void dumpIndex(File file, boolean indexSanityOnly, boolean verifyOnly, scala.collection.mutable.Map<String, List<Tuple2<Object, Object>>> misMatchesForIndexFilesMap, int maxMessageSize) {
        Object object = new Object();
        try {
            String string = file.getName().split("\\.")[0];
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            long startOffset = new StringOps(string).toLong();
            FileRecords fileRecords = FileRecords.open((File)new File(file.getAbsoluteFile().getParent(), new StringBuilder(0).append(file.getName().split("\\.")[0]).append(Log$.MODULE$.LogFileSuffix()).toString()), (boolean)false);
            boolean x$3 = false;
            int x$4 = OffsetIndex$.MODULE$.$lessinit$greater$default$3();
            OffsetIndex index = new OffsetIndex(file, startOffset, x$4, x$3);
            if (indexSanityOnly) {
                index.sanityCheck();
                Predef$.MODULE$.println((Object)new StringBuilder(21).append(file).append(" passed sanity check.").toString());
                return;
            }
            int n = 0;
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Range range = RichInt$.MODULE$.until$extension0(n, index.entries());
            if (range == null) {
                throw null;
            }
            Range foreach$mVc$sp_this = range;
            if (!foreach$mVc$sp_this.isEmpty()) {
                int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
                while (true) {
                    DumpLogSegments$.$anonfun$dumpIndex$1(index, object, fileRecords, maxMessageSize, misMatchesForIndexFilesMap, file, verifyOnly, foreach$mVc$sp_i);
                    if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                    foreach$mVc$sp_i += foreach$mVc$sp_this.step();
                }
                return;
            }
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
                return;
            }
            throw ex;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void dumpTimeIndex(File file, boolean indexSanityOnly, boolean verifyOnly, DumpLogSegments.TimeIndexDumpErrors timeIndexDumpErrors, int maxMessageSize) {
        Object object = new Object();
        try {
            String string = file.getName().split("\\.")[0];
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            long startOffset = new StringOps(string).toLong();
            FileRecords fileRecords = FileRecords.open((File)new File(file.getAbsoluteFile().getParent(), new StringBuilder(0).append(file.getName().split("\\.")[0]).append(Log$.MODULE$.LogFileSuffix()).toString()), (boolean)false);
            File indexFile = new File(file.getAbsoluteFile().getParent(), new StringBuilder(0).append(file.getName().split("\\.")[0]).append(Log$.MODULE$.IndexFileSuffix()).toString());
            boolean x$3 = false;
            int x$4 = OffsetIndex$.MODULE$.$lessinit$greater$default$3();
            OffsetIndex index = new OffsetIndex(indexFile, startOffset, x$4, x$3);
            boolean x$7 = false;
            int x$8 = TimeIndex$.MODULE$.$lessinit$greater$default$3();
            TimeIndex timeIndex = new TimeIndex(file, startOffset, x$8, x$7);
            try {
                if (indexSanityOnly) {
                    timeIndex.sanityCheck();
                    Predef$.MODULE$.println((Object)new StringBuilder(21).append(file).append(" passed sanity check.").toString());
                    return;
                }
                LongRef prevTimestamp = LongRef.create((long)-1L);
                int n = 0;
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                Range range = RichInt$.MODULE$.until$extension0(n, timeIndex.entries());
                if (range == null) {
                    throw null;
                }
                Range foreach$mVc$sp_this = range;
                if (foreach$mVc$sp_this.isEmpty()) return;
                int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
                while (true) {
                    DumpLogSegments$.$anonfun$dumpTimeIndex$1(timeIndex, object, index, fileRecords, timeIndexDumpErrors, file, prevTimestamp, verifyOnly, foreach$mVc$sp_i);
                    if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) return;
                    foreach$mVc$sp_i += foreach$mVc$sp_this.step();
                }
            }
            finally {
                fileRecords.closeHandlers();
                index.closeHandler();
                timeIndex.closeHandler();
            }
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() != object) throw ex;
            ex.value$mcV$sp();
            return;
        }
    }

    private void dumpLog(File file, boolean printContents, scala.collection.mutable.Map<String, List<Tuple2<Object, Object>>> nonConsecutivePairsForLogFilesMap, boolean isDeepIteration, int maxMessageSize, DumpLogSegments.MessageParser<?, ?> parser) {
        String string = file.getName().split("\\.")[0];
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        long startOffset = new StringOps(string).toLong();
        Predef$.MODULE$.println((Object)new StringBuilder(17).append("Starting offset: ").append(startOffset).toString());
        FileRecords fileRecords = FileRecords.open((File)file, (boolean)false);
        try {
            LongRef validBytes = LongRef.create((long)0L);
            LongRef lastOffset = LongRef.create((long)-1L);
            ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(fileRecords.batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
                DumpLogSegments$.$anonfun$dumpLog$1(validBytes, isDeepIteration, lastOffset, nonConsecutivePairsForLogFilesMap, file, printContents, parser, batch);
                return BoxedUnit.UNIT;
            });
            long trailingBytes = (long)fileRecords.sizeInBytes() - validBytes.elem;
            if (trailingBytes > 0L) {
                Predef$.MODULE$.println((Object)new StringBuilder(35).append("Found ").append(trailingBytes).append(" invalid bytes at the end of ").append(file.getName()).toString());
            }
        }
        finally {
            fileRecords.closeHandlers();
        }
    }

    private void printBatchLevel(FileLogInputStream.FileChannelRecordBatch batch, long accumulativeBytes) {
        if (batch.magic() >= 2) {
            Predef$.MODULE$.print((Object)new StringBuilder(145).append("baseOffset: ").append(batch.baseOffset()).append(" lastOffset: ").append(batch.lastOffset()).append(" count: ").append(batch.countOrNull()).append(" baseSequence: ").append(batch.baseSequence()).append(" lastSequence: ").append(batch.lastSequence()).append(" producerId: ").append(batch.producerId()).append(" producerEpoch: ").append(batch.producerEpoch()).append(" partitionLeaderEpoch: ").append(batch.partitionLeaderEpoch()).append(" isTransactional: ").append(batch.isTransactional()).append(" isControl: ").append(batch.isControlBatch()).toString());
        } else {
            Predef$.MODULE$.print((Object)new StringBuilder(8).append("offset: ").append(batch.lastOffset()).toString());
        }
        Predef$.MODULE$.println((Object)new StringBuilder(61).append(" position: ").append(accumulativeBytes).append(" ").append(batch.timestampType()).append(": ").append(batch.maxTimestamp()).append(" size: ").append(batch.sizeInBytes()).append(" magic: ").append(batch.magic()).append(" compresscodec: ").append(batch.compressionType()).append(" crc: ").append(batch.checksum()).append(" isvalid: ").append(batch.isValid()).toString());
    }

    public static final /* synthetic */ void $anonfun$main$1(DumpLogSegments.DumpLogSegmentsOptions opts$1, scala.collection.mutable.Map nonConsecutivePairsForLogFilesMap$1, scala.collection.mutable.Map misMatchesForIndexFilesMap$1, DumpLogSegments.TimeIndexDumpErrors timeIndexDumpErrors$1, String arg) {
        File file = new File(arg);
        Predef$.MODULE$.println((Object)new StringBuilder(8).append("Dumping ").append(file).toString());
        String filename = file.getName();
        String suffix = filename.substring(filename.lastIndexOf("."));
        String string = Log$.MODULE$.LogFileSuffix();
        if (!(string != null ? !string.equals(suffix) : suffix != null)) {
            MODULE$.dumpLog(file, opts$1.shouldPrintDataLog(), (scala.collection.mutable.Map<String, List<Tuple2<Object, Object>>>)nonConsecutivePairsForLogFilesMap$1, opts$1.isDeepIteration(), opts$1.maxMessageSize(), opts$1.messageParser());
            return;
        }
        String string2 = Log$.MODULE$.IndexFileSuffix();
        if (!(string2 != null ? !string2.equals(suffix) : suffix != null)) {
            MODULE$.dumpIndex(file, opts$1.indexSanityOnly(), opts$1.verifyOnly(), (scala.collection.mutable.Map<String, List<Tuple2<Object, Object>>>)misMatchesForIndexFilesMap$1, opts$1.maxMessageSize());
            return;
        }
        String string3 = Log$.MODULE$.TimeIndexFileSuffix();
        if (!(string3 != null ? !string3.equals(suffix) : suffix != null)) {
            MODULE$.dumpTimeIndex(file, opts$1.indexSanityOnly(), opts$1.verifyOnly(), timeIndexDumpErrors$1, opts$1.maxMessageSize());
            return;
        }
        String string4 = Log$.MODULE$.ProducerSnapshotFileSuffix();
        if (!(string4 != null ? !string4.equals(suffix) : suffix != null)) {
            MODULE$.dumpProducerIdSnapshot(file);
            return;
        }
        String string5 = Log$.MODULE$.TxnIndexFileSuffix();
        if (!(string5 != null ? !string5.equals(suffix) : suffix != null)) {
            MODULE$.dumpTxnIndex(file);
            return;
        }
        System.err.println(new StringBuilder(22).append("Ignoring unknown file ").append(file).toString());
    }

    public static final /* synthetic */ void $anonfun$main$3(Tuple2 x0$1) {
        if (x0$1 != null) {
            long indexOffset = x0$1._1$mcJ$sp();
            long logOffset = x0$1._2$mcJ$sp();
            System.err.println(new StringBuilder(30).append("  Index offset: ").append(indexOffset).append(", log offset: ").append(logOffset).toString());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$main$2(String fileName, List listOfMismatches) {
        System.err.println(new StringBuilder(15).append("Mismatches in :").append(fileName).toString());
        if (listOfMismatches == null) {
            throw null;
        }
        List foreach_these = listOfMismatches;
        while (!foreach_these.isEmpty()) {
            DumpLogSegments$.$anonfun$main$3((Tuple2)foreach_these.head());
            foreach_these = (List)foreach_these.tail();
        }
    }

    public static final /* synthetic */ void $anonfun$main$5(Tuple2 x0$2) {
        if (x0$2 != null) {
            long first = x0$2._1$mcJ$sp();
            long second = x0$2._2$mcJ$sp();
            System.err.println(new StringBuilder(18).append("  ").append(first).append(" is followed by ").append(second).toString());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$main$4(String fileName, List listOfNonConsecutivePairs) {
        System.err.println(new StringBuilder(27).append("Non-consecutive offsets in ").append(fileName).toString());
        if (listOfNonConsecutivePairs == null) {
            throw null;
        }
        List foreach_these = listOfNonConsecutivePairs;
        while (!foreach_these.isEmpty()) {
            DumpLogSegments$.$anonfun$main$5((Tuple2)foreach_these.head());
            foreach_these = (List)foreach_these.tail();
        }
    }

    public static final /* synthetic */ void $anonfun$dumpProducerIdSnapshot$1(ProducerStateEntry entry) {
        Predef$.MODULE$.print((Object)new StringBuilder(72).append("producerId: ").append(entry.producerId()).append(" producerEpoch: ").append(entry.producerEpoch()).append(" ").append("coordinatorEpoch: ").append(entry.coordinatorEpoch()).append(" currentTxnFirstOffset: ").append(entry.currentTxnFirstOffset()).append(" ").toString());
        Option option = entry.batchMetadata().headOption();
        if (option == null) {
            throw null;
        }
        Option foreach_this = option;
        if (!foreach_this.isEmpty()) {
            Predef$.MODULE$.print((Object)new StringBuilder(69).append("firstSequence: ").append(((BatchMetadata)foreach_this.get()).firstSeq()).append(" lastSequence: ").append(((BatchMetadata)foreach_this.get()).lastSeq()).append(" ").append("lastOffset: ").append(((BatchMetadata)foreach_this.get()).lastOffset()).append(" offsetDelta: ").append(((BatchMetadata)foreach_this.get()).offsetDelta()).append(" timestamp: ").append(((BatchMetadata)foreach_this.get()).timestamp()).toString());
        }
        Predef$.MODULE$.println();
    }

    public static final /* synthetic */ void $anonfun$dumpIndex$1(OffsetIndex index$1, Object nonLocalReturnKey1$1, FileRecords fileRecords$1, int maxMessageSize$1, scala.collection.mutable.Map misMatchesForIndexFilesMap$2, File file$1, boolean verifyOnly$1, int i) {
        OffsetPosition entry = index$1.entry(i);
        if (entry.offset() == index$1.baseOffset() && i > 0) {
            throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
        }
        long firstBatchLastOffset = ((RecordBatch)fileRecords$1.slice(entry.position(), maxMessageSize$1).batches().iterator().next()).lastOffset();
        if (firstBatchLastOffset != entry.offset()) {
            List misMatchesSeq = (List)misMatchesForIndexFilesMap$2.getOrElse((Object)file$1.getAbsolutePath(), (Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
            misMatchesSeq = misMatchesSeq.$colon$colon((Object)new Tuple2.mcJJ.sp(entry.offset(), firstBatchLastOffset));
            misMatchesForIndexFilesMap$2.put((Object)file$1.getAbsolutePath(), (Object)misMatchesSeq);
        }
        if (!verifyOnly$1) {
            Predef$.MODULE$.println((Object)new StringBuilder(19).append("offset: ").append(entry.offset()).append(" position: ").append(entry.position()).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$dumpTimeIndex$2(TimestampOffset entry$1, FileLogInputStream.FileChannelRecordBatch x$1) {
        return x$1.lastOffset() >= entry$1.offset();
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$dumpTimeIndex$1(TimeIndex timeIndex$1, Object nonLocalReturnKey2$1, OffsetIndex index$2, FileRecords fileRecords$2, DumpLogSegments.TimeIndexDumpErrors timeIndexDumpErrors$2, File file$2, LongRef prevTimestamp$1, boolean verifyOnly$2, int i) {
        block9: {
            block8: {
                entry = timeIndex$1.entry(i);
                if (entry.offset() == timeIndex$1.baseOffset() && i > 0) {
                    throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey2$1, BoxedUnit.UNIT);
                }
                position = index$2.lookup(entry.offset()).position();
                partialFileRecords = fileRecords$2.slice(position, 0x7FFFFFFF);
                batches = (Iterable)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(partialFileRecords.batches()).asScala();
                maxTimestamp = LongRef.create((long)-1L);
                var14_14 = false;
                var15_15 = null;
                var16_16 = batches.find((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$dumpTimeIndex$2$adapted(kafka.log.TimestampOffset org.apache.kafka.common.record.FileLogInputStream$FileChannelRecordBatch ), (Lorg/apache/kafka/common/record/FileLogInputStream$FileChannelRecordBatch;)Ljava/lang/Object;)((TimestampOffset)entry));
                if (!None$.MODULE$.equals(var16_16)) break block8;
                timeIndexDumpErrors$2.recordShallowOffsetNotFound(file$2, entry.offset(), -1);
                break block9;
            }
            if (!(var16_16 instanceof Some)) ** GOTO lbl-1000
            var14_14 = true;
            var15_15 = (Some)var16_16;
            batch = (FileLogInputStream.FileChannelRecordBatch)var15_15.value();
            if (batch.lastOffset() != entry.offset()) {
                timeIndexDumpErrors$2.recordShallowOffsetNotFound(file$2, entry.offset(), batch.lastOffset());
            } else if (var14_14) {
                batch = (FileLogInputStream.FileChannelRecordBatch)var15_15.value();
                ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)batch).asScala()).foreach((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$dumpTimeIndex$3$adapted(scala.runtime.LongRef org.apache.kafka.common.record.Record ), (Lorg/apache/kafka/common/record/Record;)Ljava/lang/Object;)((LongRef)maxTimestamp));
                if (maxTimestamp.elem != entry.timestamp()) {
                    timeIndexDumpErrors$2.recordMismatchTimeIndex(file$2, entry.timestamp(), maxTimestamp.elem);
                }
                if (prevTimestamp$1.elem >= entry.timestamp()) {
                    timeIndexDumpErrors$2.recordOutOfOrderIndexTimestamp(file$2, entry.timestamp(), prevTimestamp$1.elem);
                }
            } else {
                throw new MatchError((Object)var16_16);
            }
        }
        if (!verifyOnly$2) {
            Predef$.MODULE$.println((Object)new StringBuilder(20).append("timestamp: ").append(entry.timestamp()).append(" offset: ").append(entry.offset()).toString());
        }
        prevTimestamp$1.elem = entry.timestamp();
    }

    public static final /* synthetic */ void $anonfun$dumpLog$2(LongRef lastOffset$1, scala.collection.mutable.Map nonConsecutivePairsForLogFilesMap$2, File file$3, FileLogInputStream.FileChannelRecordBatch batch$1, boolean printContents$1, DumpLogSegments.MessageParser parser$1, Record record) {
        if (lastOffset$1.elem == -1L) {
            lastOffset$1.elem = record.offset();
        } else if (record.offset() != lastOffset$1.elem + 1L) {
            List nonConsecutivePairsSeq = (List)nonConsecutivePairsForLogFilesMap$2.getOrElse((Object)file$3.getAbsolutePath(), (Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
            nonConsecutivePairsSeq = nonConsecutivePairsSeq.$colon$colon((Object)new Tuple2.mcJJ.sp(lastOffset$1.elem, record.offset()));
            nonConsecutivePairsForLogFilesMap$2.put((Object)file$3.getAbsolutePath(), (Object)nonConsecutivePairsSeq);
        }
        lastOffset$1.elem = record.offset();
        Predef$.MODULE$.print((Object)new StringBuilder(34).append(MODULE$.RecordIndent()).append(" offset: ").append(record.offset()).append(" ").append(batch$1.timestampType()).append(": ").append(record.timestamp()).append(" ").append("keysize: ").append(record.keySize()).append(" valuesize: ").append(record.valueSize()).toString());
        if (batch$1.magic() >= 2) {
            Predef$.MODULE$.print((Object)new StringBuilder(24).append(" sequence: ").append(record.sequence()).append(" headerKeys: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])TraversableLike.map$((TraversableLike)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])record.headers())), (Function1 & Serializable & scala.Serializable)x$2 -> x$2.key(), (CanBuildFrom)Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("[", ",", "]")).toString());
        } else {
            Predef$.MODULE$.print((Object)new StringBuilder(16).append(" crc: ").append(record.checksumOrNull()).append(" isvalid: ").append(record.isValid()).toString());
        }
        if (batch$1.isControlBatch()) {
            short controlTypeId = ControlRecordType.parseTypeId((ByteBuffer)record.key());
            ControlRecordType controlRecordType = ControlRecordType.fromTypeId((short)controlTypeId);
            boolean bl = ControlRecordType.ABORT.equals(controlRecordType) ? true : ControlRecordType.COMMIT.equals(controlRecordType);
            if (bl) {
                EndTransactionMarker endTxnMarker = EndTransactionMarker.deserialize((Record)record);
                Predef$.MODULE$.print((Object)new StringBuilder(34).append(" endTxnMarker: ").append(endTxnMarker.controlType()).append(" coordinatorEpoch: ").append(endTxnMarker.coordinatorEpoch()).toString());
            } else {
                Predef$.MODULE$.print((Object)new StringBuilder(16).append(" controlType: ").append(controlRecordType).append("(").append(controlTypeId).append(")").toString());
            }
        } else if (printContents$1) {
            Tuple2 tuple2 = parser$1.parse(record);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            Option key = option;
            Option payload = option2;
            if (key == null) {
                throw null;
            }
            if (!key.isEmpty()) {
                Predef$.MODULE$.print((Object)new StringBuilder(6).append(" key: ").append(key.get()).toString());
            }
            if (payload == null) {
                throw null;
            }
            if (!payload.isEmpty()) {
                Predef$.MODULE$.print((Object)new StringBuilder(10).append(" payload: ").append(payload.get()).toString());
            }
        }
        Predef$.MODULE$.println();
    }

    public static final /* synthetic */ void $anonfun$dumpLog$1(LongRef validBytes$1, boolean isDeepIteration$1, LongRef lastOffset$1, scala.collection.mutable.Map nonConsecutivePairsForLogFilesMap$2, File file$3, boolean printContents$1, DumpLogSegments.MessageParser parser$1, FileLogInputStream.FileChannelRecordBatch batch) {
        MODULE$.printBatchLevel(batch, validBytes$1.elem);
        if (isDeepIteration$1) {
            ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)batch).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
                DumpLogSegments$.$anonfun$dumpLog$2(lastOffset$1, nonConsecutivePairsForLogFilesMap$2, file$3, batch, printContents$1, parser$1, record);
                return BoxedUnit.UNIT;
            });
        }
        validBytes$1.elem += (long)batch.sizeInBytes();
    }

    private DumpLogSegments$() {
        MODULE$ = this;
        this.RecordIndent = "|";
    }

    public static final /* synthetic */ Object $anonfun$main$1$adapted(DumpLogSegments.DumpLogSegmentsOptions opts$1, scala.collection.mutable.Map nonConsecutivePairsForLogFilesMap$1, scala.collection.mutable.Map misMatchesForIndexFilesMap$1, DumpLogSegments.TimeIndexDumpErrors timeIndexDumpErrors$1, String arg) {
        DumpLogSegments$.$anonfun$main$1(opts$1, nonConsecutivePairsForLogFilesMap$1, misMatchesForIndexFilesMap$1, timeIndexDumpErrors$1, arg);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$dumpTxnIndex$1$adapted(AbortedTxn abortedTxn) {
        Predef$.MODULE$.println((Object)new StringBuilder(68).append("version: ").append(abortedTxn.version()).append(" producerId: ").append(abortedTxn.producerId()).append(" firstOffset: ").append(abortedTxn.firstOffset()).append(" ").append("lastOffset: ").append(abortedTxn.lastOffset()).append(" lastStableOffset: ").append(abortedTxn.lastStableOffset()).toString());
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$main$3$adapted(Tuple2 x0$1) {
        DumpLogSegments$.$anonfun$main$3(x0$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$main$5$adapted(Tuple2 x0$2) {
        DumpLogSegments$.$anonfun$main$5(x0$2);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$dumpProducerIdSnapshot$2$adapted(BatchMetadata metadata) {
        Predef$.MODULE$.print((Object)new StringBuilder(69).append("firstSequence: ").append(metadata.firstSeq()).append(" lastSequence: ").append(metadata.lastSeq()).append(" ").append("lastOffset: ").append(metadata.lastOffset()).append(" offsetDelta: ").append(metadata.offsetDelta()).append(" timestamp: ").append(metadata.timestamp()).toString());
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$dumpTimeIndex$2$adapted(TimestampOffset entry$1, FileLogInputStream.FileChannelRecordBatch x$1) {
        return BoxesRunTime.boxToBoolean((boolean)DumpLogSegments$.$anonfun$dumpTimeIndex$2(entry$1, x$1));
    }

    public static final /* synthetic */ Object $anonfun$dumpTimeIndex$3$adapted(LongRef maxTimestamp$1, Record record) {
        maxTimestamp$1.elem = scala.math.package$.MODULE$.max(maxTimestamp$1.elem, record.timestamp());
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$dumpLog$5$adapted(Object key) {
        Predef$.MODULE$.print((Object)new StringBuilder(6).append(" key: ").append(key).toString());
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$dumpLog$6$adapted(Object payload) {
        Predef$.MODULE$.print((Object)new StringBuilder(10).append(" payload: ").append(payload).toString());
        return BoxedUnit.UNIT;
    }
}

