/*
 * Decompiled with CFR 0.152.
 */
package kafka.common;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import kafka.common.InterBrokerSendThread$;
import kafka.common.RequestAndCompletionHandler;
import kafka.common.UnsentRequests;
import kafka.utils.ShutdownableThread;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.RequestCompletionHandler;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.internals.FatalExitError;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LongRef;

@ScalaSignature(bytes="\u0006\u0001\u0005-c!\u0002\f\u0018\u0003\u0003a\u0002\"C\u0012\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u00132\u0011!\u0011\u0004A!A!\u0002\u0013\u0019\u0004\u0002\u0003 \u0001\u0005\u0003\u0005\u000b\u0011B \t\u0013\u0015\u0003!\u0011!Q\u0001\n\u0019S\u0005\"B&\u0001\t\u0003a\u0005\"B*\u0001\r\u0003!\u0006\"B1\u0001\r\u0003\u0011\u0007b\u00024\u0001\u0005\u0004%Ia\u001a\u0005\u0007W\u0002\u0001\u000b\u0011\u00025\t\u000b1\u0004A\u0011A7\t\u000b9\u0004A\u0011I8\t\u000bM\u0004A\u0011I8\t\u000bQ\u0004A\u0011B;\t\u000bm\u0004A\u0011\u0002?\t\u000by\u0004A\u0011B@\t\u000f\u0005\r\u0001\u0001\"\u0001\u0002\u0006!1\u00111\u0005\u0001\u0005\u0002=<\u0011\"!\n\u0018\u0003\u0003E\t!a\n\u0007\u0011Y9\u0012\u0011!E\u0001\u0003SAaaS\n\u0005\u0002\u0005E\u0002\"CA\u001a'E\u0005I\u0011AA\u001b\u0005UIe\u000e^3s\u0005J|7.\u001a:TK:$G\u000b\u001b:fC\u0012T!\u0001G\r\u0002\r\r|W.\\8o\u0015\u0005Q\u0012!B6bM.\f7\u0001A\n\u0003\u0001u\u0001\"AH\u0011\u000e\u0003}Q!\u0001I\r\u0002\u000bU$\u0018\u000e\\:\n\u0005\tz\"AE*ikR$wn\u001e8bE2,G\u000b\u001b:fC\u0012\fAA\\1nKB\u0011QE\f\b\u0003M1\u0002\"a\n\u0016\u000e\u0003!R!!K\u000e\u0002\rq\u0012xn\u001c;?\u0015\u0005Y\u0013!B:dC2\f\u0017BA\u0017+\u0003\u0019\u0001&/\u001a3fM&\u0011q\u0006\r\u0002\u0007'R\u0014\u0018N\\4\u000b\u00055R\u0013BA\u0012\"\u00035qW\r^<pe.\u001cE.[3oiB\u0011A\u0007P\u0007\u0002k)\u0011agN\u0001\bG2LWM\u001c;t\u0015\tQ\u0002H\u0003\u0002:u\u00051\u0011\r]1dQ\u0016T\u0011aO\u0001\u0004_J<\u0017BA\u001f6\u0005-Y\u0015MZ6b\u00072LWM\u001c;\u0002\tQLW.\u001a\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0003A\tS!\u0001G\u001c\n\u0005\u0011\u000b%\u0001\u0002+j[\u0016\fq\"[:J]R,'O];qi&\u0014G.\u001a\t\u0003\u000f\"k\u0011AK\u0005\u0003\u0013*\u0012qAQ8pY\u0016\fg.\u0003\u0002FC\u00051A(\u001b8jiz\"R!T(Q#J\u0003\"A\u0014\u0001\u000e\u0003]AQaI\u0003A\u0002\u0011BQAM\u0003A\u0002MBQAP\u0003A\u0002}Bq!R\u0003\u0011\u0002\u0003\u0007a)\u0001\thK:,'/\u0019;f%\u0016\fX/Z:ugR\tQ\u000bE\u0002W7zs!aV-\u000f\u0005\u001dB\u0016\"A\u0016\n\u0005iS\u0013a\u00029bG.\fw-Z\u0005\u00039v\u0013\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0006\u00035*\u0002\"AT0\n\u0005\u0001<\"a\u0007*fcV,7\u000f^!oI\u000e{W\u000e\u001d7fi&|g\u000eS1oI2,'/\u0001\tsKF,Xm\u001d;US6,w.\u001e;NgV\t1\r\u0005\u0002HI&\u0011QM\u000b\u0002\u0004\u0013:$\u0018AD;og\u0016tGOU3rk\u0016\u001cHo]\u000b\u0002QB\u0011a*[\u0005\u0003U^\u0011a\"\u00168tK:$(+Z9vKN$8/A\bv]N,g\u000e\u001e*fcV,7\u000f^:!\u0003EA\u0017m]+og\u0016tGOU3rk\u0016\u001cHo]\u000b\u0002\r\u0006A1\u000f[;uI><h\u000eF\u0001q!\t9\u0015/\u0003\u0002sU\t!QK\\5u\u0003\u0019!wnV8sW\u0006a1/\u001a8e%\u0016\fX/Z:ugR\u0011a/\u001f\t\u0003\u000f^L!\u0001\u001f\u0016\u0003\t1{gn\u001a\u0005\u0006u6\u0001\rA^\u0001\u0004]><\u0018\u0001E2iK\u000e\\G)[:d_:tWm\u0019;t)\t\u0001X\u0010C\u0003{\u001d\u0001\u0007a/A\ngC&dW\t\u001f9je\u0016$'+Z9vKN$8\u000fF\u0002q\u0003\u0003AQA_\bA\u0002Y\facY8na2,G/Z,ji\"$\u0015n]2p]:,7\r\u001e\u000b\ba\u0006\u001d\u0011\u0011CA\n\u0011\u001d\tI\u0001\u0005a\u0001\u0003\u0017\tqA]3rk\u0016\u001cH\u000fE\u00025\u0003\u001bI1!a\u00046\u00055\u0019E.[3oiJ+\u0017/^3ti\")!\u0010\u0005a\u0001m\"9\u0011Q\u0003\tA\u0002\u0005]\u0011aF1vi\",g\u000e^5dCRLwN\\#yG\u0016\u0004H/[8o!\u0011\tI\"a\b\u000e\u0005\u0005m!bAA\u000f\u0005\u00061QM\u001d:peNLA!!\t\u0002\u001c\t9\u0012)\u001e;iK:$\u0018nY1uS>tW\t_2faRLwN\\\u0001\u0007o\u0006\\W-\u001e9\u0002+%sG/\u001a:Ce>\\WM]*f]\u0012$\u0006N]3bIB\u0011ajE\n\u0004'\u0005-\u0002cA$\u0002.%\u0019\u0011q\u0006\u0016\u0003\r\u0005s\u0017PU3g)\t\t9#A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003oQ3ARA\u001dW\t\tY\u0004\u0005\u0003\u0002>\u0005\u001dSBAA \u0015\u0011\t\t%a\u0011\u0002\u0013Ut7\r[3dW\u0016$'bAA#U\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005%\u0013q\b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public abstract class InterBrokerSendThread
extends ShutdownableThread {
    private final KafkaClient networkClient;
    private final Time time;
    private final UnsentRequests unsentRequests;

    public static boolean $lessinit$greater$default$4() {
        return InterBrokerSendThread$.MODULE$.$lessinit$greater$default$4();
    }

    public abstract Iterable<RequestAndCompletionHandler> generateRequests();

    public abstract int requestTimeoutMs();

    private UnsentRequests unsentRequests() {
        return this.unsentRequests;
    }

    public boolean hasUnsentRequests() {
        return this.unsentRequests().iterator().hasNext();
    }

    @Override
    public void shutdown() {
        this.initiateShutdown();
        this.networkClient.wakeup();
        this.awaitShutdown();
    }

    @Override
    public void doWork() {
        LongRef now = LongRef.create((long)this.time.milliseconds());
        this.generateRequests().foreach((Function1 & Serializable & scala.Serializable)request -> {
            InterBrokerSendThread.$anonfun$doWork$1(this, now, request);
            return BoxedUnit.UNIT;
        });
        try {
            long timeout = this.sendRequests(now.elem);
            this.networkClient.poll(timeout, now.elem);
            now.elem = this.time.milliseconds();
            this.checkDisconnects(now.elem);
            this.failExpiredRequests(now.elem);
            this.unsentRequests().clean();
            return;
        }
        catch (FatalExitError fatalExitError) {
            throw fatalExitError;
        }
        catch (Throwable t) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "unhandled exception caught in InterBrokerSendThread", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
            throw new FatalExitError();
        }
    }

    private long sendRequests(long now) {
        LongRef pollTimeout = LongRef.create((long)Long.MAX_VALUE);
        ((IterableLike)CollectionConverters$.MODULE$.asScalaSetConverter(this.unsentRequests().nodes()).asScala()).foreach((Function1 & Serializable & scala.Serializable)node -> {
            InterBrokerSendThread.$anonfun$sendRequests$1(this, now, pollTimeout, node);
            return BoxedUnit.UNIT;
        });
        return pollTimeout.elem;
    }

    private void checkDisconnects(long now) {
        Iterator<Map.Entry<Node, ArrayDeque<ClientRequest>>> iterator = this.unsentRequests().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Node, ArrayDeque<ClientRequest>> entry = iterator.next();
            ArrayDeque<ClientRequest> arrayDeque = entry.getValue();
            Node node = entry.getKey();
            ArrayDeque<ClientRequest> arrayDeque2 = arrayDeque;
            Node node2 = node;
            ArrayDeque<ClientRequest> requests = arrayDeque2;
            if (requests.isEmpty() || !this.networkClient.connectionFailed(node2)) continue;
            iterator.remove();
            ((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(requests).asScala()).foreach((Function1 & Serializable & scala.Serializable)request -> {
                InterBrokerSendThread.$anonfun$checkDisconnects$1(this, node2, now, request);
                return BoxedUnit.UNIT;
            });
        }
    }

    private void failExpiredRequests(long now) {
        Collection<ClientRequest> timedOutRequests = this.unsentRequests().removeAllTimedOut(now);
        ((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(timedOutRequests).asScala()).foreach((Function1 & Serializable & scala.Serializable)request -> {
            InterBrokerSendThread.$anonfun$failExpiredRequests$1(this, now, request);
            return BoxedUnit.UNIT;
        });
    }

    public void completeWithDisconnect(ClientRequest request, long now, AuthenticationException authenticationException) {
        RequestCompletionHandler handler = request.callback();
        handler.onComplete(new ClientResponse(request.makeHeader(request.requestBuilder().latestAllowedVersion()), handler, request.destination(), now, now, true, null, authenticationException, null));
    }

    public void wakeup() {
        this.networkClient.wakeup();
    }

    public static final /* synthetic */ void $anonfun$doWork$1(InterBrokerSendThread $this, LongRef now$1, RequestAndCompletionHandler request) {
        RequestCompletionHandler completionHandler = request.handler();
        $this.unsentRequests().put(request.destination(), $this.networkClient.newClientRequest(request.destination().idString(), request.request(), now$1.elem, true, $this.requestTimeoutMs(), completionHandler));
    }

    public static final /* synthetic */ void $anonfun$sendRequests$1(InterBrokerSendThread $this, long now$2, LongRef pollTimeout$1, Node node) {
        Iterator<ClientRequest> requestIterator = $this.unsentRequests().requestIterator(node);
        while (requestIterator.hasNext()) {
            ClientRequest request = requestIterator.next();
            if ($this.networkClient.ready(node, now$2)) {
                $this.networkClient.send(request, now$2);
                requestIterator.remove();
                continue;
            }
            pollTimeout$1.elem = Math.min(pollTimeout$1.elem, $this.networkClient.connectionDelay(node, now$2));
        }
    }

    public static final /* synthetic */ void $anonfun$checkDisconnects$1(InterBrokerSendThread $this, Node node$1, long now$3, ClientRequest request) {
        AuthenticationException authenticationException = $this.networkClient.authenticationException(node$1);
        if (authenticationException != null) {
            $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append("Failed to send the following request due to authentication error: ").append(request).toString());
        }
        $this.completeWithDisconnect(request, now$3, authenticationException);
    }

    public static final /* synthetic */ void $anonfun$failExpiredRequests$1(InterBrokerSendThread $this, long now$4, ClientRequest request) {
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Failed to send the following request after ").append(request.requestTimeoutMs()).append(" ms: ").append(request).toString());
        $this.completeWithDisconnect(request, now$4, null);
    }

    public InterBrokerSendThread(String name, KafkaClient networkClient, Time time, boolean isInterruptible) {
        this.networkClient = networkClient;
        this.time = time;
        super(name, isInterruptible);
        this.unsentRequests = new UnsentRequests();
    }
}

