/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.io;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Comparator;
import java.util.Set;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.encryption.EncryptedOutputFile;
import org.apache.iceberg.io.FileWriter;
import org.apache.iceberg.io.OutputFileFactory;
import org.apache.iceberg.io.PartitioningWriter;
import org.apache.iceberg.io.StructCopy;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.Comparators;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.StructLikeSet;

abstract class ClusteredWriter<T, R>
implements PartitioningWriter<T, R> {
    private static final String NOT_CLUSTERED_ROWS_ERROR_MSG_TEMPLATE = "Incoming records violate the writer assumption that records are clustered by spec and by partition within each spec. Either cluster the incoming records or switch to fanout writers.\nEncountered records that belong to already closed files:\n";
    private final Set<Integer> completedSpecIds = Sets.newHashSet();
    private PartitionSpec currentSpec = null;
    private Comparator<StructLike> partitionComparator = null;
    private Set<StructLike> completedPartitions = null;
    private StructLike currentPartition = null;
    private FileWriter<T, R> currentWriter = null;
    private boolean closed = false;

    ClusteredWriter() {
    }

    protected abstract FileWriter<T, R> newWriter(PartitionSpec var1, StructLike var2);

    protected abstract void addResult(R var1);

    protected abstract R aggregatedResult();

    @Override
    public void write(T row, PartitionSpec spec, StructLike partition) {
        if (!spec.equals((Object)this.currentSpec)) {
            if (this.currentSpec != null) {
                this.closeCurrentWriter();
                this.completedSpecIds.add(this.currentSpec.specId());
                this.completedPartitions.clear();
            }
            if (this.completedSpecIds.contains(spec.specId())) {
                String errorCtx = String.format("spec %s", spec);
                throw new IllegalStateException(NOT_CLUSTERED_ROWS_ERROR_MSG_TEMPLATE + errorCtx);
            }
            Types.StructType partitionType = spec.partitionType();
            this.currentSpec = spec;
            this.partitionComparator = Comparators.forType((Types.StructType)partitionType);
            this.completedPartitions = StructLikeSet.create(partitionType);
            this.currentPartition = StructCopy.copy(partition);
            this.currentWriter = this.newWriter(this.currentSpec, this.currentPartition);
        } else if (partition != this.currentPartition && this.partitionComparator.compare(partition, this.currentPartition) != 0) {
            this.closeCurrentWriter();
            this.completedPartitions.add(this.currentPartition);
            if (this.completedPartitions.contains(partition)) {
                String errorCtx = String.format("partition '%s' in spec %s", spec.partitionToPath(partition), spec);
                throw new IllegalStateException(NOT_CLUSTERED_ROWS_ERROR_MSG_TEMPLATE + errorCtx);
            }
            this.currentPartition = StructCopy.copy(partition);
            this.currentWriter = this.newWriter(this.currentSpec, this.currentPartition);
        }
        this.currentWriter.write(row);
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closeCurrentWriter();
            this.closed = true;
        }
    }

    private void closeCurrentWriter() {
        if (this.currentWriter != null) {
            try {
                this.currentWriter.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to close current writer", e);
            }
            this.addResult(this.currentWriter.result());
            this.currentWriter = null;
        }
    }

    @Override
    public final R result() {
        Preconditions.checkState((boolean)this.closed, (Object)"Cannot get result from unclosed writer");
        return this.aggregatedResult();
    }

    protected EncryptedOutputFile newOutputFile(OutputFileFactory fileFactory, PartitionSpec spec, StructLike partition) {
        Preconditions.checkArgument((spec.isUnpartitioned() || partition != null ? 1 : 0) != 0, (Object)"Partition must not be null when creating output file for partitioned spec");
        return partition == null ? fileFactory.newOutputFile() : fileFactory.newOutputFile(spec, partition);
    }
}

