/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.actions;

import java.util.Set;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.RewriteFiles;
import org.apache.iceberg.Table;
import org.apache.iceberg.actions.BaseCommitService;
import org.apache.iceberg.actions.RewritePositionDeletesGroup;
import org.apache.iceberg.exceptions.CommitStateUnknownException;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RewritePositionDeletesCommitManager {
    private static final Logger LOG = LoggerFactory.getLogger(RewritePositionDeletesCommitManager.class);
    private final Table table;
    private final long startingSnapshotId;

    public RewritePositionDeletesCommitManager(Table table) {
        this.table = table;
        this.startingSnapshotId = table.currentSnapshot().snapshotId();
    }

    public void commit(Set<RewritePositionDeletesGroup> fileGroups) {
        RewriteFiles rewriteFiles = this.table.newRewrite().validateFromSnapshot(this.startingSnapshotId);
        for (RewritePositionDeletesGroup group : fileGroups) {
            for (DeleteFile file : group.rewrittenDeleteFiles()) {
                rewriteFiles.deleteFile(file);
            }
            for (DeleteFile file : group.addedDeleteFiles()) {
                rewriteFiles.addFile(file, group.maxRewrittenDataSequenceNumber());
            }
        }
        rewriteFiles.commit();
    }

    public void abort(RewritePositionDeletesGroup fileGroup) {
        Preconditions.checkState((fileGroup.addedDeleteFiles() != null ? 1 : 0) != 0, (Object)"Cannot abort a fileGroup that was not rewritten");
        Iterable filePaths = Iterables.transform(fileGroup.addedDeleteFiles(), f -> f.path().toString());
        CatalogUtil.deleteFiles(this.table.io(), filePaths, "position delete", true);
    }

    public void commitOrClean(Set<RewritePositionDeletesGroup> rewriteGroups) {
        try {
            this.commit(rewriteGroups);
        }
        catch (CommitStateUnknownException e) {
            LOG.error("Commit state unknown for {}, cannot clean up files because they may have been committed successfully.", rewriteGroups, (Object)e);
            throw e;
        }
        catch (Exception e) {
            LOG.error("Cannot commit groups {}, attempting to clean up written files", rewriteGroups, (Object)e);
            rewriteGroups.forEach(this::abort);
            throw e;
        }
    }

    public CommitService service(int rewritesPerCommit) {
        return new CommitService(rewritesPerCommit);
    }

    public class CommitService
    extends BaseCommitService<RewritePositionDeletesGroup> {
        CommitService(int rewritesPerCommit) {
            super(RewritePositionDeletesCommitManager.this.table, rewritesPerCommit);
        }

        @Override
        protected void commitOrClean(Set<RewritePositionDeletesGroup> batch) {
            RewritePositionDeletesCommitManager.this.commitOrClean(batch);
        }

        @Override
        protected void abortFileGroup(RewritePositionDeletesGroup group) {
            RewritePositionDeletesCommitManager.this.abort(group);
        }
    }
}

