/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.protocol.node.extract;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.inlong.common.enums.MetaField;
import org.apache.inlong.sort.formats.util.StringUtils;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.InlongMetric;
import org.apache.inlong.sort.protocol.Metadata;
import org.apache.inlong.sort.protocol.node.ExtractNode;
import org.apache.inlong.sort.protocol.node.format.Format;
import org.apache.inlong.sort.protocol.node.format.InLongMsgFormat;
import org.apache.inlong.sort.protocol.transformation.WatermarkField;

@JsonTypeName(value="tubeMQExtract")
public class TubeMQExtractNode
extends ExtractNode
implements Serializable,
InlongMetric,
Metadata {
    private static final long serialVersionUID = -2544747886429528474L;
    @Nonnull
    @JsonProperty(value="masterRpc")
    private String masterRpc;
    @Nonnull
    @JsonProperty(value="topic")
    private String topic;
    @Nonnull
    @JsonProperty(value="format")
    private Format format;
    @Nonnull
    @JsonProperty(value="consumeGroup")
    private String consumeGroup;
    @JsonProperty(value="sessionKey")
    private String sessionKey;
    @JsonProperty(value="streamId")
    private TreeSet<String> streamId;

    @JsonCreator
    public TubeMQExtractNode(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="fields") List<FieldInfo> fields, @Nullable @JsonProperty(value="watermarkField") WatermarkField waterMarkField, @JsonProperty(value="properties") Map<String, String> properties, @Nonnull @JsonProperty(value="masterRpc") String masterRpc, @Nonnull @JsonProperty(value="topic") String topic, @Nonnull @JsonProperty(value="format") Format format, @Nonnull @JsonProperty(value="consumeGroup") String consumeGroup, @JsonProperty(value="sessionKey") String sessionKey, @JsonProperty(value="streamId") TreeSet<String> streamId) {
        super(id, name, fields, waterMarkField, properties);
        this.masterRpc = Preconditions.checkNotNull(masterRpc, "TubeMQ masterRpc is null");
        this.topic = Preconditions.checkNotNull(topic, "TubeMQ topic is null");
        this.format = Preconditions.checkNotNull(format, "Format is null");
        this.consumeGroup = Preconditions.checkNotNull(consumeGroup, "Group id is null");
        this.sessionKey = sessionKey;
        this.streamId = streamId;
    }

    @Override
    public Map<String, String> tableOptions() {
        Map<String, String> map = super.tableOptions();
        map.put("connector", "tubemq-inlong");
        map.putAll(this.format.generateOptions(false));
        map.put("topic", this.topic);
        map.put("master.rpc", this.masterRpc);
        map.put("consume.group", this.consumeGroup);
        map.put("session.key", this.sessionKey);
        if (null != this.streamId && !this.streamId.isEmpty()) {
            map.put("stream.id", StringUtils.concatCsv(this.streamId.toArray(new String[0]), Character.valueOf(','), null, null));
        }
        return map;
    }

    @Override
    public String genTableName() {
        return String.format("table_%s", super.getId());
    }

    @Override
    public String getMetadataKey(MetaField metaField) {
        String metadataKey;
        switch (metaField) {
            case AUDIT_DATA_TIME: {
                if (this.format instanceof InLongMsgFormat) {
                    metadataKey = "value.data-time";
                    break;
                }
                metadataKey = "consume_time";
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupported meta field for %s: %s", new Object[]{this.getClass().getSimpleName(), metaField}));
            }
        }
        return metadataKey;
    }

    @Override
    public boolean isVirtual(MetaField metaField) {
        return true;
    }

    @Override
    public Set<MetaField> supportedMetaFields() {
        return EnumSet.of(MetaField.AUDIT_DATA_TIME);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TubeMQExtractNode)) {
            return false;
        }
        TubeMQExtractNode other = (TubeMQExtractNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$masterRpc = this.getMasterRpc();
        String other$masterRpc = other.getMasterRpc();
        if (this$masterRpc == null ? other$masterRpc != null : !this$masterRpc.equals(other$masterRpc)) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
            return false;
        }
        Format this$format = this.getFormat();
        Format other$format = other.getFormat();
        if (this$format == null ? other$format != null : !this$format.equals(other$format)) {
            return false;
        }
        String this$consumeGroup = this.getConsumeGroup();
        String other$consumeGroup = other.getConsumeGroup();
        if (this$consumeGroup == null ? other$consumeGroup != null : !this$consumeGroup.equals(other$consumeGroup)) {
            return false;
        }
        String this$sessionKey = this.getSessionKey();
        String other$sessionKey = other.getSessionKey();
        if (this$sessionKey == null ? other$sessionKey != null : !this$sessionKey.equals(other$sessionKey)) {
            return false;
        }
        TreeSet<String> this$streamId = this.getStreamId();
        TreeSet<String> other$streamId = other.getStreamId();
        return !(this$streamId == null ? other$streamId != null : !((Object)this$streamId).equals(other$streamId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TubeMQExtractNode;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $masterRpc = this.getMasterRpc();
        result = result * 59 + ($masterRpc == null ? 43 : $masterRpc.hashCode());
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        Format $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : $format.hashCode());
        String $consumeGroup = this.getConsumeGroup();
        result = result * 59 + ($consumeGroup == null ? 43 : $consumeGroup.hashCode());
        String $sessionKey = this.getSessionKey();
        result = result * 59 + ($sessionKey == null ? 43 : $sessionKey.hashCode());
        TreeSet<String> $streamId = this.getStreamId();
        result = result * 59 + ($streamId == null ? 43 : ((Object)$streamId).hashCode());
        return result;
    }

    @Nonnull
    public String getMasterRpc() {
        return this.masterRpc;
    }

    @Nonnull
    public String getTopic() {
        return this.topic;
    }

    @Nonnull
    public Format getFormat() {
        return this.format;
    }

    @Nonnull
    public String getConsumeGroup() {
        return this.consumeGroup;
    }

    public String getSessionKey() {
        return this.sessionKey;
    }

    public TreeSet<String> getStreamId() {
        return this.streamId;
    }

    public void setMasterRpc(@Nonnull String masterRpc) {
        if (masterRpc == null) {
            throw new NullPointerException("masterRpc is marked non-null but is null");
        }
        this.masterRpc = masterRpc;
    }

    public void setTopic(@Nonnull String topic) {
        if (topic == null) {
            throw new NullPointerException("topic is marked non-null but is null");
        }
        this.topic = topic;
    }

    public void setFormat(@Nonnull Format format) {
        if (format == null) {
            throw new NullPointerException("format is marked non-null but is null");
        }
        this.format = format;
    }

    public void setConsumeGroup(@Nonnull String consumeGroup) {
        if (consumeGroup == null) {
            throw new NullPointerException("consumeGroup is marked non-null but is null");
        }
        this.consumeGroup = consumeGroup;
    }

    public void setSessionKey(String sessionKey) {
        this.sessionKey = sessionKey;
    }

    public void setStreamId(TreeSet<String> streamId) {
        this.streamId = streamId;
    }

    @Override
    public String toString() {
        return "TubeMQExtractNode(masterRpc=" + this.getMasterRpc() + ", topic=" + this.getTopic() + ", format=" + this.getFormat() + ", consumeGroup=" + this.getConsumeGroup() + ", sessionKey=" + this.getSessionKey() + ", streamId=" + this.getStreamId() + ")";
    }
}

