/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.protocol.ddl.Utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.jsqlparser.statement.create.table.ColDataType;
import net.sf.jsqlparser.statement.create.table.ColumnDefinition;
import org.apache.inlong.sort.protocol.ddl.enums.PositionType;
import org.apache.inlong.sort.protocol.ddl.expressions.Column;
import org.apache.inlong.sort.protocol.ddl.expressions.Position;

public class ColumnUtils {
    public static final String DEFAULT = "default";
    public static final String NULL = "null";
    public static final String NOT = "not";
    public static final String COMMENT = "comment";
    public static final String AFTER = "after";

    public static Column parseColumnWithPosition(boolean isFirst, Map<String, Integer> sqlType, ColumnDefinition columnDefinition) {
        ColDataType colDataType = columnDefinition.getColDataType();
        ArrayList<String> definitions = new ArrayList<String>();
        if (colDataType.getArgumentsStringList() != null) {
            definitions.addAll(colDataType.getArgumentsStringList());
        }
        List<String> columnSpecs = columnDefinition.getColumnSpecs();
        Column.ColumnBuilder columnBuilder = Column.builder();
        String columnName = ColumnUtils.reformatName(columnDefinition.getColumnName());
        columnBuilder.name(columnName).definition(definitions).isNullable(ColumnUtils.parseNullable(columnSpecs)).defaultValue(ColumnUtils.parseDefaultValue(columnSpecs)).jdbcType(sqlType.get(columnName)).comment(ColumnUtils.parseComment(columnSpecs));
        if (isFirst) {
            columnBuilder.position(new Position(PositionType.FIRST, null));
        } else {
            columnBuilder.position(ColumnUtils.parsePosition(columnSpecs));
        }
        return columnBuilder.build();
    }

    public static List<Column> parseColumns(Map<String, Integer> sqlType, List<ColumnDefinition> columnDefinitions) {
        ArrayList<Column> columns = new ArrayList<Column>();
        columnDefinitions.forEach(columnDefinition -> columns.add(ColumnUtils.parseColumnWithPosition(false, sqlType, columnDefinition)));
        return columns;
    }

    public static String parseDefaultValue(List<String> specs) {
        return ColumnUtils.removeContinuousQuotes(ColumnUtils.parseAdjacentString(specs, DEFAULT, false));
    }

    public static boolean parseNullable(List<String> specs) {
        return !ColumnUtils.parseAdjacentString(specs, NULL, true).equalsIgnoreCase(NOT);
    }

    public static String parseComment(List<String> specs) {
        return ColumnUtils.removeContinuousQuotes(ColumnUtils.parseAdjacentString(specs, COMMENT, false));
    }

    public static Position parsePosition(List<String> specs) {
        String afterColumn = ColumnUtils.reformatName(ColumnUtils.parseAdjacentString(specs, AFTER, false));
        if (!afterColumn.isEmpty()) {
            return new Position(PositionType.AFTER, afterColumn);
        }
        return null;
    }

    public static String parseAdjacentString(List<String> stringList, String specificString, boolean front) {
        if (stringList == null || stringList.isEmpty()) {
            return "";
        }
        for (int i = 0; i < stringList.size(); ++i) {
            if (!stringList.get(i).equalsIgnoreCase(specificString)) continue;
            if (front && i > 0) {
                return stringList.get(i - 1);
            }
            if (i >= stringList.size() - 1) continue;
            return stringList.get(i + 1);
        }
        return "";
    }

    public static String removeContinuousChar(String str, char target) {
        int start;
        if (str == null || str.length() < 2) {
            return str;
        }
        int end = str.length() - 1;
        for (start = 0; start <= end && str.charAt(start) == target; ++start) {
        }
        while (end >= start && str.charAt(end) == target) {
            --end;
        }
        return str.substring(start, end + 1);
    }

    public static String removeContinuousQuotes(String str) {
        return ColumnUtils.removeContinuousChar(str, '\'');
    }

    public static String reformatName(String str) {
        return ColumnUtils.removeContinuousChar(str, '`');
    }
}

