/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.parser.result;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.List;
import org.apache.flink.table.api.StatementSet;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableResult;
import org.apache.inlong.common.util.MaskDataUtils;
import org.apache.inlong.sort.parser.result.ParseResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkSqlParseResult
implements ParseResult,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(FlinkSqlParseResult.class);
    private static final long serialVersionUID = -28762188896227462L;
    private final TableEnvironment tableEnv;
    private final List<String> createTableSqls;
    private final List<String> loadSqls;

    public FlinkSqlParseResult(TableEnvironment tableEnv, List<String> createTableSqls, List<String> loadSqls) {
        this.tableEnv = Preconditions.checkNotNull(tableEnv, "tableEnv is null");
        this.createTableSqls = Preconditions.checkNotNull(createTableSqls, "createTableSqls is null");
        Preconditions.checkState(!createTableSqls.isEmpty(), "createTableSqls is empty");
        this.loadSqls = Preconditions.checkNotNull(loadSqls, "loadSqls is null");
        Preconditions.checkState(!loadSqls.isEmpty(), "loadSqls is empty");
    }

    @Override
    public void execute() throws Exception {
        this.executeCreateTableSqls(this.createTableSqls);
        this.executeLoadSqls(this.loadSqls);
    }

    @Override
    public void waitExecute() throws Exception {
        this.executeCreateTableSqls(this.createTableSqls);
        this.executeLoadSqls(this.loadSqls).await();
    }

    @Override
    public boolean tryExecute() throws Exception {
        this.executeCreateTableSqls(this.createTableSqls);
        return this.executeLoadSqls(this.loadSqls) != null;
    }

    private TableResult executeLoadSqls(List<String> sqls) {
        StatementSet st = this.tableEnv.createStatementSet();
        for (String sql : sqls) {
            log.info("execute loadSql:\n{}", (Object)sql);
            st.addInsertSql(sql);
        }
        return st.execute();
    }

    private void executeCreateTableSqls(List<String> sqls) {
        for (String sql : sqls) {
            log.info("execute createSql:\n{}", (Object)MaskDataUtils.maskSensitiveMessage(sql));
            this.tableEnv.executeSql(sql);
        }
    }

    public TableEnvironment getTableEnv() {
        return this.tableEnv;
    }

    public List<String> getCreateTableSqls() {
        return this.createTableSqls;
    }

    public List<String> getLoadSqls() {
        return this.loadSqls;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlinkSqlParseResult)) {
            return false;
        }
        FlinkSqlParseResult other = (FlinkSqlParseResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TableEnvironment this$tableEnv = this.getTableEnv();
        TableEnvironment other$tableEnv = other.getTableEnv();
        if (this$tableEnv == null ? other$tableEnv != null : !this$tableEnv.equals(other$tableEnv)) {
            return false;
        }
        List<String> this$createTableSqls = this.getCreateTableSqls();
        List<String> other$createTableSqls = other.getCreateTableSqls();
        if (this$createTableSqls == null ? other$createTableSqls != null : !((Object)this$createTableSqls).equals(other$createTableSqls)) {
            return false;
        }
        List<String> this$loadSqls = this.getLoadSqls();
        List<String> other$loadSqls = other.getLoadSqls();
        return !(this$loadSqls == null ? other$loadSqls != null : !((Object)this$loadSqls).equals(other$loadSqls));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FlinkSqlParseResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TableEnvironment $tableEnv = this.getTableEnv();
        result = result * 59 + ($tableEnv == null ? 43 : $tableEnv.hashCode());
        List<String> $createTableSqls = this.getCreateTableSqls();
        result = result * 59 + ($createTableSqls == null ? 43 : ((Object)$createTableSqls).hashCode());
        List<String> $loadSqls = this.getLoadSqls();
        result = result * 59 + ($loadSqls == null ? 43 : ((Object)$loadSqls).hashCode());
        return result;
    }

    public String toString() {
        return "FlinkSqlParseResult(tableEnv=" + this.getTableEnv() + ", createTableSqls=" + this.getCreateTableSqls() + ", loadSqls=" + this.getLoadSqls() + ")";
    }
}

