/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.formats.inlongmsg.row;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DelegatingConfiguration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.DeserializationFormatFactory;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.SerializationFormatFactory;
import org.apache.inlong.sort.formats.inlongmsg.InLongMsgOptions;
import org.apache.inlong.sort.formats.inlongmsg.row.InLongMsgDecodingFormat;

public final class InLongMsgFormatFactory
implements DeserializationFormatFactory,
SerializationFormatFactory {
    public static final String IDENTIFIER = "inlong-msg";
    public static final String INLONG_PREFIX = "inlong-msg.";

    public DecodingFormat<DeserializationSchema<RowData>> createDecodingFormat(DynamicTableFactory.Context context, ReadableConfig formatOptions) {
        InLongMsgOptions.validateDecodingFormatOptions(formatOptions);
        DeserializationFormatFactory innerFactory = (DeserializationFormatFactory)FactoryUtil.discoverFactory((ClassLoader)context.getClassLoader(), DeserializationFormatFactory.class, (String)((String)formatOptions.get(InLongMsgOptions.INNER_FORMAT)));
        Configuration allOptions = Configuration.fromMap((Map)context.getCatalogTable().getOptions());
        String innerFormatMetaPrefix = (String)formatOptions.get(InLongMsgOptions.INNER_FORMAT) + ".";
        String innerFormatPrefix = INLONG_PREFIX + innerFormatMetaPrefix;
        DecodingFormat innerFormat = innerFactory.createDecodingFormat(context, (ReadableConfig)new DelegatingConfiguration(allOptions, innerFormatPrefix));
        return new InLongMsgDecodingFormat((DecodingFormat<DeserializationSchema<RowData>>)innerFormat, innerFormatMetaPrefix, formatOptions);
    }

    public EncodingFormat<SerializationSchema<RowData>> createEncodingFormat(DynamicTableFactory.Context context, ReadableConfig formatOptions) {
        throw new RuntimeException("Do not support inlong format serialize.");
    }

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet options = new HashSet();
        options.add(InLongMsgOptions.INNER_FORMAT);
        return options;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(InLongMsgOptions.IGNORE_PARSE_ERRORS);
        options.add(InLongMsgOptions.CSV_IGNORE_TRAILING_UNMAPPABLE);
        options.add(InLongMsgOptions.CSV_INSERT_NULLS_FOR_MISSING_COLUMNS);
        options.add(InLongMsgOptions.CSV_EMPTY_STRING_AS_NULL);
        options.add(InLongMsgOptions.CSV_IGNORE_PARSE_ERRORS);
        return options;
    }
}

