/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.formats.inlongmsg.row;

import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.apache.inlong.sort.formats.inlongmsg.row.InLongMsgMixedFormatConverter;
import org.apache.inlong.sort.formats.inlongmsg.row.InLongMsgUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInLongMsgMixedFormatConverter
implements InLongMsgMixedFormatConverter {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractInLongMsgMixedFormatConverter.class);
    private final boolean ignoreErrors;

    public AbstractInLongMsgMixedFormatConverter(boolean ignoreErrors) {
        this.ignoreErrors = ignoreErrors;
    }

    public abstract List<Row> convertRows(Map<String, String> var1, byte[] var2, String var3, Timestamp var4, List<String> var5, List<String> var6, Map<String, String> var7) throws Exception;

    public void flatMap(Row row, Collector<Row> collector) throws Exception {
        List<Row> convertedRows;
        try {
            Map<String, String> attributes = InLongMsgUtils.getAttributesFromMixedRow(row);
            byte[] data = InLongMsgUtils.getDataFromMixedRow(row);
            String streamId = InLongMsgUtils.getStreamIdFromMixedRow(row);
            Timestamp time = InLongMsgUtils.getTimeFromMixedRow(row);
            List<String> predefinedFields = InLongMsgUtils.getPredefinedFieldsFromMixedRow(row);
            List<String> fields = InLongMsgUtils.getFieldsFromMixedRow(row);
            Map<String, String> entries = InLongMsgUtils.getEntriesFromMixedRow(row);
            convertedRows = this.convertRows(attributes, data, streamId, time, predefinedFields, fields, entries);
        }
        catch (Throwable t2) {
            String errorMessage = String.format("Could not properly convert the mixed row. Row=[%s].", row);
            if (this.ignoreErrors) {
                LOG.warn(errorMessage, t2);
                return;
            }
            throw new RuntimeException(errorMessage, t2);
        }
        if (convertedRows != null) {
            for (Row convertedRow : convertedRows) {
                collector.collect((Object)convertedRow);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractInLongMsgMixedFormatConverter that = (AbstractInLongMsgMixedFormatConverter)o;
        return Objects.equals(this.ignoreErrors, that.ignoreErrors);
    }

    public int hashCode() {
        return Objects.hash(this.ignoreErrors);
    }

    public static interface TableFormatContext {
        public MetricGroup getMetricGroup();

        public Map<String, String> getFormatProperties();
    }
}

