/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.formats.csv;

import java.nio.charset.Charset;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.types.Row;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.FormatInfo;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.RowFormatInfo;
import org.apache.inlong.sort.formats.base.DefaultSerializationSchema;
import org.apache.inlong.sort.formats.base.TableFormatUtils;
import org.apache.inlong.sort.formats.csv.CsvFormatBuilder;
import org.apache.inlong.sort.formats.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvSerializationSchema
extends DefaultSerializationSchema<Row> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(CsvSerializationSchema.class);
    private final RowFormatInfo rowFormatInfo;
    @Nonnull
    private final String charset;
    @Nonnull
    private final Character delimiter;
    @Nullable
    private final Character escapeChar;
    @Nullable
    private final Character quoteChar;
    @Nullable
    private final String nullLiteral;

    public CsvSerializationSchema(@Nonnull RowFormatInfo rowFormatInfo, @Nonnull String charset, @Nonnull Character delimiter, @Nullable Character escapeChar, @Nullable Character quoteChar, @Nullable String nullLiteral, boolean ignoreErrors) {
        super(ignoreErrors);
        this.rowFormatInfo = rowFormatInfo;
        this.charset = charset;
        this.delimiter = delimiter;
        this.escapeChar = escapeChar;
        this.quoteChar = quoteChar;
        this.nullLiteral = nullLiteral;
    }

    public CsvSerializationSchema(@Nonnull RowFormatInfo rowFormatInfo) {
        this(rowFormatInfo, "UTF-8", Character.valueOf(','), null, null, null, false);
    }

    @Override
    protected byte[] serializeInternal(Row row) {
        if (row == null) {
            return null;
        }
        try {
            String[] fieldNames = this.rowFormatInfo.getFieldNames();
            FormatInfo[] fieldFormatInfos = this.rowFormatInfo.getFieldFormatInfos();
            if (row.getArity() != fieldFormatInfos.length) {
                LOG.warn("The number of fields mismatches: expected=[{}], actual=[{}]. Row=[{}].", fieldNames.length, row.getArity(), row);
            }
            String[] fieldTexts = new String[fieldNames.length];
            for (int i = 0; i < fieldNames.length; ++i) {
                String fieldText;
                fieldTexts[i] = i >= row.getArity() ? (this.nullLiteral == null ? "" : this.nullLiteral) : (fieldText = TableFormatUtils.serializeBasicField(fieldNames[i], fieldFormatInfos[i], row.getField(i), this.nullLiteral));
            }
            String result = StringUtils.concatCsv(fieldTexts, this.delimiter, this.escapeChar, this.quoteChar);
            return result.getBytes(Charset.forName(this.charset));
        }
        catch (Throwable t2) {
            throw new RuntimeException(String.format("Could not properly serialize csv. Row=[%s].", row), t2);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CsvSerializationSchema that = (CsvSerializationSchema)o;
        return Objects.equals(this.rowFormatInfo, that.rowFormatInfo) && Objects.equals(this.charset, that.charset) && Objects.equals(this.delimiter, that.delimiter) && Objects.equals(this.escapeChar, that.escapeChar) && Objects.equals(this.quoteChar, that.quoteChar) && Objects.equals(this.nullLiteral, that.nullLiteral);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.rowFormatInfo, this.charset, this.delimiter, this.escapeChar, this.quoteChar, this.nullLiteral);
    }

    public static class Builder
    extends CsvFormatBuilder<Builder> {
        public Builder(RowFormatInfo rowFormatInfo) {
            super(rowFormatInfo);
        }

        public CsvSerializationSchema build() {
            return new CsvSerializationSchema(this.rowFormatInfo, this.charset, Character.valueOf(this.delimiter), this.escapeChar, this.quoteChar, this.nullLiteral, this.ignoreErrors);
        }
    }
}

