/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.validation.feature;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.sf.jsqlparser.parser.feature.Feature;
import net.sf.jsqlparser.parser.feature.FeatureSet;
import net.sf.jsqlparser.parser.feature.ModifyableFeatureSet;
import net.sf.jsqlparser.util.validation.ValidationException;
import net.sf.jsqlparser.util.validation.feature.FeatureSetValidation;

public class FeaturesAllowed
implements FeatureSetValidation,
ModifyableFeatureSet {
    private static final String SEPERATOR_REGEX = " \\+ ";
    private static final String SEPERATOR = " + ";
    public static final FeaturesAllowed JDBC = new FeaturesAllowed("jdbc", Feature.jdbcParameter, Feature.jdbcNamedParameter).unmodifyable();
    public static final FeaturesAllowed EXPRESSIONS = new FeaturesAllowed("EXPRESSIONS", Feature.exprLike, Feature.exprSimilarTo);
    public static final FeaturesAllowed SELECT = new FeaturesAllowed("SELECT", Feature.select, Feature.selectGroupBy, Feature.selectHaving, Feature.join, Feature.joinOuterSimple, Feature.joinSimple, Feature.joinRight, Feature.joinNatural, Feature.joinFull, Feature.joinLeft, Feature.joinCross, Feature.joinOuter, Feature.joinSemi, Feature.joinInner, Feature.joinStraight, Feature.joinApply, Feature.joinWindow, Feature.joinUsingColumns, Feature.limit, Feature.limitNull, Feature.limitAll, Feature.limitOffset, Feature.offset, Feature.offsetParam, Feature.fetch, Feature.fetchFirst, Feature.fetchNext, Feature.skip, Feature.first, Feature.top, Feature.optimizeFor, Feature.selectUnique, Feature.distinct, Feature.distinctOn, Feature.orderBy, Feature.orderByNullOrdering, Feature.function).unmodifyable();
    public static final FeaturesAllowed INSERT = new FeaturesAllowed("INSERT", Feature.insert, Feature.insertFromSelect, Feature.insertModifierIgnore, Feature.insertModifierPriority, Feature.insertReturningAll, Feature.insertReturningExpressionList, Feature.insertUseSet, Feature.insertValues, Feature.selectInto).add(SELECT).unmodifyable();
    public static final FeaturesAllowed UPDATE = new FeaturesAllowed("UPDATE", Feature.update, Feature.updateJoins, Feature.updateFrom, Feature.updateLimit, Feature.updateOrderBy, Feature.updateReturning, Feature.updateUseSelect).add(SELECT).unmodifyable();
    public static final FeaturesAllowed DELETE = new FeaturesAllowed("DELETE", Feature.delete, Feature.deleteJoin, Feature.deleteLimit, Feature.deleteOrderBy, Feature.deleteTables, Feature.deleteReturningExpressionList, Feature.truncate).add(SELECT).unmodifyable();
    public static final FeaturesAllowed MERGE = new FeaturesAllowed("MERGE", Feature.merge, Feature.upsert, Feature.insertUseDuplicateKeyUpdate).unmodifyable();
    public static final FeaturesAllowed DML = new FeaturesAllowed("DML", new Feature[0]).add(SELECT, INSERT, UPDATE, DELETE, MERGE).unmodifyable();
    public static final FeaturesAllowed EXECUTE = new FeaturesAllowed("EXECUTE", Feature.execute).unmodifyable();
    public static final FeaturesAllowed CREATE = new FeaturesAllowed("CREATE", Feature.createIndex, Feature.createSchema, Feature.createSequence, Feature.createTable, Feature.createTableUnlogged, Feature.createTableCreateOptionStrings, Feature.createTableTableOptionStrings, Feature.createTableIfNotExists, Feature.createTableRowMovement, Feature.createTableFromSelect, Feature.createTrigger, Feature.createView).unmodifyable();
    public static final FeaturesAllowed ALTER = new FeaturesAllowed("ALTER", Feature.alterTable, Feature.alterSequence, Feature.alterView, Feature.alterIndex).unmodifyable();
    public static final FeaturesAllowed DROP = new FeaturesAllowed("DROP", Feature.drop, Feature.dropTable, Feature.dropIndex, Feature.dropView, Feature.dropSchema, Feature.dropSequence, Feature.dropTableIfExists, Feature.dropIndexIfExists, Feature.dropViewIfExists, Feature.dropSchemaIfExists, Feature.dropSequenceIfExists).unmodifyable();
    public static final FeaturesAllowed DDL = new FeaturesAllowed("DDL", new Feature[0]).add(CREATE, ALTER, DROP).unmodifyable();
    private Set<String> names = new LinkedHashSet<String>();
    private Set<Feature> features = new HashSet<Feature>();

    public FeaturesAllowed(Feature ... features) {
        this.add(features);
    }

    public FeaturesAllowed(String name, Feature ... features) {
        this.names.add(name);
        this.add(features);
    }

    @Override
    public FeaturesAllowed add(FeatureSet ... featureSets) {
        Stream.of(featureSets).forEach(fs -> {
            this.features.addAll(fs.getFeatures());
            if (fs instanceof FeatureSetValidation) {
                this.names.addAll(this.collectNames((FeatureSetValidation)fs));
            }
        });
        return this;
    }

    @Override
    public FeaturesAllowed add(Feature ... features) {
        Collections.addAll(this.features, features);
        return this;
    }

    @Override
    public FeaturesAllowed add(Collection<Feature> features) {
        this.features.addAll(features);
        return this;
    }

    @Override
    public FeaturesAllowed remove(FeatureSet ... featureSets) {
        Stream.of(featureSets).forEach(fs -> {
            this.features.removeAll(fs.getFeatures());
            if (fs instanceof FeatureSetValidation) {
                this.names.removeAll(this.collectNames((FeatureSetValidation)fs));
            }
        });
        return this;
    }

    @Override
    public FeaturesAllowed remove(Feature ... features) {
        this.features.removeAll(Arrays.asList(features));
        return this;
    }

    @Override
    public FeaturesAllowed remove(Collection<Feature> features) {
        this.features.removeAll(features);
        return this;
    }

    @Override
    public FeaturesAllowed copy() {
        return new FeaturesAllowed(new Feature[0]).add(this);
    }

    @Override
    public FeaturesAllowed unmodifyable() {
        this.features = Collections.unmodifiableSet(this.features);
        return this;
    }

    @Override
    public ValidationException getMessage(Feature feature) {
        return this.toError(feature.name() + " not allowed.");
    }

    @Override
    public String getName() {
        return this.names.isEmpty() ? FeatureSetValidation.super.getName() : this.names.stream().collect(Collectors.joining(SEPERATOR));
    }

    @Override
    public Set<Feature> getFeatures() {
        return this.features;
    }

    private List<String> collectNames(FeatureSetValidation fs) {
        String name = fs.getName();
        return Stream.of(name.split(SEPERATOR_REGEX)).map(String::trim).collect(Collectors.toList());
    }
}

