/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.corebase.utils;

public enum RegexDef {
    TMP_FILTER(0, "^[_A-Za-z0-9\\-]+$", "must only contain English letters, numbers, hyphens, and underscores"),
    TMP_STRING(1, "^[a-zA-Z]\\w+$", "must begin with a letter, can only contain English letters, numbers, and underscores"),
    TMP_NUMBER(2, "^-?[0-9]\\d*$", "must only contain numbers"),
    TMP_GROUP(3, "^[a-zA-Z][\\w-]+$", "must begin with a letter, can only contain English letters, numbers, hyphens, and underscores"),
    TMP_CONSUMERID(4, "^[_A-Za-z0-9\\.\\-]+$", "must begin with a letter, can only contain English letters, numbers, dot, scores, and underscores"),
    TMP_IPV4ADDRESS(5, "((?:(?:25[0-5]|2[0-4]\\d|((1\\d{2})|([1-9]?\\d)))\\.){3}(?:25[0-5]|2[0-4]\\d|((1\\d{2})|([1-9]?\\d))))", "must matches the IPv4 address regulation");

    private final int id;
    private final String pattern;
    private final String errMsgTemp;

    private RegexDef(int id, String pattern, String errMsgTemp) {
        this.id = id;
        this.pattern = pattern;
        this.errMsgTemp = errMsgTemp;
    }

    public int getId() {
        return this.id;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getErrMsgTemp() {
        return this.errMsgTemp;
    }
}

